/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.commands;

import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunTabCompleter;
import io.github.thebusybiscuit.slimefun4.core.commands.SubCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.subcommands.Commands;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class SlimefunCommand
implements CommandExecutor,
Listener {
    private final SlimefunPlugin plugin;
    private final List<SubCommand> commands = new LinkedList<SubCommand>();
    private final Map<SubCommand, Integer> commandUsage = new HashMap<SubCommand, Integer>();

    public SlimefunCommand(SlimefunPlugin plugin) {
        this.plugin = plugin;
    }

    public void register() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.plugin.getCommand("slimefun").setExecutor((CommandExecutor)this);
        this.plugin.getCommand("slimefun").setTabCompleter((TabCompleter)new SlimefunTabCompleter(this));
        Commands.addCommands(this, this.commands);
    }

    public SlimefunPlugin getPlugin() {
        return this.plugin;
    }

    public Map<SubCommand, Integer> getCommandUsage() {
        return this.commandUsage;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length > 0) {
            for (SubCommand command : this.commands) {
                if (!args[0].equalsIgnoreCase(command.getName())) continue;
                command.recordUsage(this.commandUsage);
                command.onExecute(sender, args);
                return true;
            }
        }
        this.sendHelp(sender);
        return true;
    }

    public void sendHelp(CommandSender sender) {
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&aSlimefun &2v" + SlimefunPlugin.getVersion()));
        sender.sendMessage("");
        for (SubCommand cmd : this.commands) {
            if (cmd.isHidden()) continue;
            sender.sendMessage(ChatColors.color("&3/sf " + cmd.getName() + " &b") + cmd.getDescription(sender));
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent e) {
        if (e.getMessage().equalsIgnoreCase("/help slimefun")) {
            this.sendHelp((CommandSender)e.getPlayer());
            e.setCancelled(true);
        }
    }

    public List<String> getSubCommandNames() {
        return this.commands.stream().map(SubCommand::getName).collect(Collectors.toList());
    }
}

