/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WitherAssembler
extends SimpleSlimefunItem<BlockTicker>
implements EnergyNetComponent {
    private static final int ENERGY_CONSUMPTION = 4096;
    private final int[] border = new int[]{0, 2, 3, 4, 5, 6, 8, 12, 14, 21, 23, 30, 32, 39, 40, 41};
    private final int[] skullBorder = new int[]{9, 10, 11, 18, 20, 27, 29, 36, 37, 38};
    private final int[] sandBorder = new int[]{15, 16, 17, 24, 26, 33, 35, 42, 43, 44};
    private int lifetime = 0;

    public WitherAssembler(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        new BlockMenuPreset(this.getID(), "&5Wither Assembler"){

            @Override
            public void init() {
                WitherAssembler.this.constructMenu(this);
            }

            @Override
            public void newInstance(BlockMenu menu, Block b) {
                if (!BlockStorage.hasBlockInfo(b) || BlockStorage.getLocationInfo(b.getLocation(), "enabled") == null || BlockStorage.getLocationInfo(b.getLocation(), "enabled").equals(String.valueOf(false))) {
                    menu.replaceExistingItem(22, new CustomItem(Material.GUNPOWDER, "&7Enabled: &4\u2718", "", "&e> Click to enable this Machine"));
                    menu.addMenuClickHandler(22, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo(b, "enabled", String.valueOf(true));
                        this.newInstance(menu, b);
                        return false;
                    });
                } else {
                    menu.replaceExistingItem(22, new CustomItem(Material.REDSTONE, "&7Enabled: &2\u2714", "", "&e> Click to disable this Machine"));
                    menu.addMenuClickHandler(22, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo(b, "enabled", String.valueOf(false));
                        this.newInstance(menu, b);
                        return false;
                    });
                }
                double offset = !BlockStorage.hasBlockInfo(b) || BlockStorage.getLocationInfo(b.getLocation(), "offset") == null ? 3.0 : Double.valueOf(BlockStorage.getLocationInfo(b.getLocation(), "offset"));
                menu.replaceExistingItem(31, new CustomItem(Material.PISTON, "&7Offset: &3" + offset + " Block(s)", "", "&rLeft Click: &7+0.1", "&rRight Click: &7-0.1"));
                menu.addMenuClickHandler(31, (p, slot, item, action) -> {
                    double offsetv = DoubleHandler.fixDouble(Double.valueOf(BlockStorage.getLocationInfo(b.getLocation(), "offset")) + (double)(action.isRightClicked() ? -0.1f : 0.1f));
                    BlockStorage.addBlockInfo(b, "offset", String.valueOf(offsetv));
                    this.newInstance(menu, b);
                    return false;
                });
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.ACCESS_INVENTORIES);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return WitherAssembler.this.getInputSlots();
                }
                return new int[0];
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.INSERT && item != null) {
                    if (item.getType() == Material.SOUL_SAND) {
                        return WitherAssembler.this.getSoulSandSlots();
                    }
                    if (item.getType() == Material.WITHER_SKELETON_SKULL) {
                        return WitherAssembler.this.getWitherSkullSlots();
                    }
                }
                return new int[0];
            }
        };
        WitherAssembler.registerBlockHandler(this.getID(), new SlimefunBlockHandler(){

            @Override
            public void onPlace(Player p, Block b, SlimefunItem item) {
                BlockStorage.addBlockInfo(b, "offset", "3.0");
                BlockStorage.addBlockInfo(b, "enabled", String.valueOf(false));
            }

            @Override
            public boolean onBreak(Player p, Block b, SlimefunItem item, UnregisterReason reason) {
                if (reason == UnregisterReason.EXPLODE) {
                    return false;
                }
                BlockMenu inv = BlockStorage.getInventory(b);
                if (inv != null) {
                    for (int slot : WitherAssembler.this.getSoulSandSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                    for (int slot : WitherAssembler.this.getWitherSkullSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                }
                return true;
            }
        });
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : this.border) {
            preset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.skullBorder) {
            preset.addItem(i, new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.sandBorder) {
            preset.addItem(i, new CustomItem(Material.BROWN_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(1, new CustomItem(Material.WITHER_SKELETON_SKULL, "&7Wither Skull Slot", "", "&rThis Slot accepts Wither Skeleton Skulls"), ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(7, new CustomItem(Material.SOUL_SAND, "&7Soul Sand Slot", "", "&rThis Slot accepts Soul Sand"), ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(13, new CustomItem(Material.CLOCK, "&7Cooldown: &b30 Seconds", "", "&rThis Machine takes up to half a Minute to operate", "&rso give it some Time!"), ChestMenuUtils.getEmptyClickHandler());
    }

    public int[] getInputSlots() {
        return new int[]{19, 28, 25, 34};
    }

    public int[] getWitherSkullSlots() {
        return new int[]{19, 28};
    }

    public int[] getSoulSandSlots() {
        return new int[]{25, 34};
    }

    @Override
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    @Override
    public int getCapacity() {
        return 4096;
    }

    @Override
    public BlockTicker getItemHandler() {
        return new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                if (String.valueOf(false).equals(BlockStorage.getLocationInfo(b.getLocation(), "enabled"))) {
                    return;
                }
                if (WitherAssembler.this.lifetime % 60 == 0 && ChargableBlock.getCharge(b) >= 4096) {
                    BlockMenu menu = BlockStorage.getInventory(b);
                    boolean soulsand = WitherAssembler.this.findResource(menu, Material.SOUL_SAND, 4, WitherAssembler.this.getSoulSandSlots());
                    boolean skulls = WitherAssembler.this.findResource(menu, Material.WITHER_SKELETON_SKULL, 3, WitherAssembler.this.getWitherSkullSlots());
                    if (soulsand && skulls) {
                        WitherAssembler.this.consumeResources(menu);
                        ChargableBlock.addCharge(b, -4096);
                        double offset = Double.parseDouble(BlockStorage.getLocationInfo(b.getLocation(), "offset"));
                        Slimefun.runSync(() -> b.getWorld().spawnEntity(new Location(b.getWorld(), (double)b.getX() + 0.5, (double)b.getY() + offset, (double)b.getZ() + 0.5), EntityType.WITHER));
                    }
                }
            }

            @Override
            public void uniqueTick() {
                WitherAssembler.this.lifetime++;
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }
        };
    }

    private boolean findResource(BlockMenu menu, Material resource, int required, int[] slots) {
        int found = 0;
        for (int slot : slots) {
            if (!SlimefunUtils.isItemSimilar(menu.getItemInSlot(slot), new ItemStack(resource), true, false) || (found += menu.getItemInSlot(slot).getAmount()) <= required) continue;
            return true;
        }
        return false;
    }

    private void consumeResources(BlockMenu inv) {
        int amount;
        int soulsand = 4;
        int skulls = 3;
        for (int slot : this.getSoulSandSlots()) {
            if (!SlimefunUtils.isItemSimilar(inv.getItemInSlot(slot), new ItemStack(Material.SOUL_SAND), true, false)) continue;
            amount = inv.getItemInSlot(slot).getAmount();
            if (amount >= soulsand) {
                inv.consumeItem(slot, soulsand);
                break;
            }
            soulsand -= amount;
            inv.replaceExistingItem(slot, null);
        }
        for (int slot : this.getWitherSkullSlots()) {
            if (!SlimefunUtils.isItemSimilar(inv.getItemInSlot(slot), new ItemStack(Material.WITHER_SKELETON_SKULL), true, false)) continue;
            amount = inv.getItemInSlot(slot).getAmount();
            if (amount >= skulls) {
                inv.consumeItem(slot, skulls);
                break;
            }
            skulls -= amount;
            inv.replaceExistingItem(slot, null);
        }
    }
}

