/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.ArrayList;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollections;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.inventory.ItemStack;

class ExplosiveTool
extends SimpleSlimefunItem<BlockBreakHandler>
implements NotPlaceable,
DamageableItem {
    private final ItemSetting<Boolean> damageOnUse = new ItemSetting<Boolean>("damage-on-use", true);
    private final ItemSetting<Boolean> callExplosionEvent = new ItemSetting<Boolean>("call-explosion-event", false);

    public ExplosiveTool(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(this.damageOnUse, this.callExplosionEvent);
    }

    @Override
    public BlockBreakHandler getItemHandler() {
        return new BlockBreakHandler(){

            @Override
            public boolean isPrivate() {
                return false;
            }

            @Override
            public boolean onBlockBreak(BlockBreakEvent e, ItemStack item, int fortune, List<ItemStack> drops) {
                if (ExplosiveTool.this.isItem(item)) {
                    Player p = e.getPlayer();
                    if (Slimefun.hasUnlocked(p, ExplosiveTool.this, true)) {
                        Block b = e.getBlock();
                        b.getWorld().createExplosion(b.getLocation(), 0.0f);
                        b.getWorld().playSound(b.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 0.2f, 1.0f);
                        List blocks = ExplosiveTool.this.findBlocks(b);
                        ExplosiveTool.this.breakBlocks(p, item, b, blocks, fortune, drops);
                    }
                    return true;
                }
                return false;
            }
        };
    }

    private void breakBlocks(Player p, ItemStack item, Block b, List<Block> blocks, int fortune, List<ItemStack> drops) {
        block3: {
            block2: {
                if (!this.callExplosionEvent.getValue().booleanValue()) break block2;
                BlockExplodeEvent blockExplodeEvent = new BlockExplodeEvent(b, blocks, 0.0f);
                Bukkit.getServer().getPluginManager().callEvent((Event)blockExplodeEvent);
                if (blockExplodeEvent.isCancelled()) break block3;
                for (Block block : blockExplodeEvent.blockList()) {
                    this.breakBlock(p, item, block, fortune, drops);
                }
                break block3;
            }
            for (Block block : blocks) {
                this.breakBlock(p, item, block, fortune, drops);
            }
        }
    }

    private List<Block> findBlocks(Block b) {
        ArrayList<Block> blocks = new ArrayList<Block>(26);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    blocks.add(b.getRelative(x, y, z));
                }
            }
        }
        return blocks;
    }

    @Override
    public boolean isDamageable() {
        return this.damageOnUse.getValue();
    }

    protected void breakBlock(Player p, ItemStack item, Block b, int fortune, List<ItemStack> drops) {
        if (!b.isEmpty() && !b.isLiquid() && !MaterialCollections.getAllUnbreakableBlocks().contains(b.getType()) && SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.BREAK_BLOCK)) {
            SlimefunPlugin.getProtectionManager().logAction((OfflinePlayer)p, b, ProtectableAction.BREAK_BLOCK);
            b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
            SlimefunItem sfItem = BlockStorage.check(b);
            if (sfItem != null && !sfItem.useVanillaBlockBreaking()) {
                SlimefunBlockHandler handler = SlimefunPlugin.getRegistry().getBlockHandlers().get(sfItem.getID());
                if (handler != null && !handler.onBreak(p, b, sfItem, UnregisterReason.PLAYER_BREAK)) {
                    drops.add(BlockStorage.retrieve(b));
                }
            } else if (b.getType() == Material.PLAYER_HEAD || b.getType().name().endsWith("_SHULKER_BOX")) {
                b.breakNaturally();
            } else {
                boolean applyFortune = b.getType().name().endsWith("_ORE") && b.getType() != Material.IRON_ORE && b.getType() != Material.GOLD_ORE;
                for (ItemStack drop : b.getDrops(this.getItem())) {
                    if (drop == null || drop.getType() == Material.AIR) continue;
                    b.getWorld().dropItemNaturally(b.getLocation(), (ItemStack)(applyFortune ? new CustomItem(drop, fortune) : drop));
                }
                b.setType(Material.AIR);
            }
            this.damageItem(p, item);
        }
    }
}

