/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.mrCookieSlime.Slimefun.cscorelib2.data.ComputedOptional;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;

public class Contributor {
    private static final String PLACEHOLDER_HEAD = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDZiYTYzMzQ0ZjQ5ZGQxYzRmNTQ4OGU5MjZiZjNkOWUyYjI5OTE2YTZjNTBkNjEwYmI0MGE1MjczZGM4YzgyIn19fQ==";
    private final String githubUsername;
    private final String minecraftUsername;
    private final String profileLink;
    private final ConcurrentMap<String, Integer> contributions = new ConcurrentHashMap<String, Integer>();
    private final ComputedOptional<String> headTexture = ComputedOptional.createNew();
    private Optional<UUID> uuid = Optional.empty();
    private boolean locked = false;

    public Contributor(String username, String profile) {
        Validate.notNull((Object)username, (String)"Username must never be null!");
        Validate.notNull((Object)profile, (String)"The profile link must never be null!");
        this.githubUsername = profile.substring(profile.lastIndexOf(47) + 1);
        this.minecraftUsername = username;
        this.profileLink = profile;
    }

    public Contributor(String username) {
        Validate.notNull((Object)username, (String)"Username must never be null!");
        this.githubUsername = username;
        this.minecraftUsername = username;
        this.profileLink = null;
    }

    public void setContribution(String role, int commits) {
        if (!this.locked || role.startsWith("translator,")) {
            this.contributions.put(role, commits);
        }
    }

    public String getName() {
        return this.githubUsername;
    }

    public String getMinecraftName() {
        return this.minecraftUsername;
    }

    public String getProfile() {
        return this.profileLink;
    }

    public List<Map.Entry<String, Integer>> getContributions() {
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(this.contributions.entrySet());
        list.sort(Comparator.comparingInt(entry -> -((Integer)entry.getValue()).intValue()));
        return list;
    }

    public int getContributions(String role) {
        return this.contributions.getOrDefault(role, 0);
    }

    public void setUniqueId(UUID uuid) {
        this.uuid = uuid == null ? Optional.empty() : Optional.of(uuid);
    }

    public Optional<UUID> getUniqueId() {
        return this.uuid;
    }

    public String getTexture() {
        if (!this.headTexture.isComputed() || !this.headTexture.isPresent()) {
            return PLACEHOLDER_HEAD;
        }
        return this.headTexture.get();
    }

    public boolean hasTexture() {
        return this.headTexture.isComputed();
    }

    public void setTexture(String skin) {
        this.headTexture.compute(skin);
    }

    public int getTotalContributions() {
        return this.contributions.values().stream().mapToInt(Integer::intValue).sum();
    }

    public int index() {
        return -this.getTotalContributions();
    }

    public String getDisplayName() {
        return ChatColor.GRAY + this.githubUsername + (!this.githubUsername.equals(this.minecraftUsername) ? ChatColor.DARK_GRAY + " (MC: " + this.minecraftUsername + ")" : "");
    }

    public void lock() {
        this.locked = true;
    }
}

