/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.magical;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemDropHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SoulboundRune
extends SimpleSlimefunItem<ItemDropHandler> {
    public SoulboundRune(Category category, SlimefunItemStack item, RecipeType type, ItemStack[] recipe) {
        super(category, item, type, recipe);
    }

    @Override
    public ItemDropHandler getItemHandler() {
        return (e, p, droppedItem) -> {
            ItemStack item = droppedItem.getItemStack();
            if (this.isItem(item)) {
                if (!Slimefun.hasUnlocked(p, SlimefunItems.SOULBOUND_RUNE, true)) {
                    return true;
                }
                Slimefun.runSync(() -> {
                    if (!droppedItem.isValid()) {
                        return;
                    }
                    Location l = droppedItem.getLocation();
                    Collection entites = l.getWorld().getNearbyEntities(l, 1.5, 1.5, 1.5, this::findCompatibleItem);
                    if (entites.isEmpty()) {
                        return;
                    }
                    Entity entity = (Entity)entites.stream().findFirst().get();
                    ItemStack target = ((Item)entity).getItemStack();
                    Item targetItem = (Item)entity;
                    SlimefunUtils.setSoulbound(target, true);
                    if (target.getAmount() == 1) {
                        e.setCancelled(true);
                        l.getWorld().strikeLightningEffect(l);
                        Slimefun.runSync(() -> {
                            if (droppedItem.isValid() && targetItem.isValid() && target.getAmount() == 1) {
                                l.getWorld().createExplosion(l, 0.0f);
                                l.getWorld().playSound(l, Sound.ENTITY_GENERIC_EXPLODE, 0.3f, 1.0f);
                                targetItem.remove();
                                droppedItem.remove();
                                l.getWorld().dropItemNaturally(l, target);
                                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.soulbound-rune.success", true);
                            }
                        }, 10L);
                    } else {
                        SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.soulbound-rune.fail", true);
                    }
                }, 20L);
                return true;
            }
            return false;
        };
    }

    public void apply(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        lore.add(ChatColor.GRAY + "Soulbound");
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    private boolean findCompatibleItem(Entity n) {
        if (n instanceof Item) {
            Item item = (Item)n;
            return !SlimefunUtils.isSoulbound(item.getItemStack()) && !this.isItem(item.getItemStack());
        }
        return false;
    }
}

