/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.chat.json;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.CustomBookInterface;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.plugin.Plugin;

public class CustomBookListener
implements Listener {
    protected static final String TRIGGER = "written_book:open - ";
    private final Set<UUID> players = new HashSet<UUID>();
    private final Map<UUID, CustomBookInterface> books = new HashMap<UUID, CustomBookInterface>();

    public CustomBookListener(Plugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent e) {
        CustomBookInterface book = this.books.get(e.getPlayer().getUniqueId());
        if (!e.getMessage().startsWith(TRIGGER)) {
            this.books.remove(e.getPlayer().getUniqueId());
        } else {
            e.setCancelled(true);
            if (book != null) {
                for (Map.Entry<NamespacedKey, Consumer<Player>> entry : book.getClickables().entrySet()) {
                    if (!e.getMessage().equals(TRIGGER + entry.getKey().toString())) continue;
                    entry.getValue().accept(e.getPlayer());
                    break;
                }
            }
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        this.players.remove(e.getPlayer().getUniqueId());
        this.books.remove(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onKick(PlayerKickEvent e) {
        this.players.remove(e.getPlayer().getUniqueId());
        this.books.remove(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        this.books.remove(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        if (this.players.contains(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onSwap(PlayerSwapHandItemsEvent e) {
        if (this.players.contains(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (this.players.contains(e.getWhoClicked().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public Map<UUID, CustomBookInterface> getBooks() {
        return this.books;
    }
}

