/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.core.services.PersistentDataService;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.plugin.Plugin;

public class BlockDataService
implements PersistentDataService,
Keyed {
    private final NamespacedKey namespacedKey;

    public BlockDataService(Plugin plugin, String key) {
        this.namespacedKey = new NamespacedKey(plugin, key);
    }

    public NamespacedKey getKey() {
        return this.namespacedKey;
    }

    public void setBlockData(Block b, String value) {
        BlockState state = b.getState();
        if (state instanceof TileState) {
            this.setString((TileState)state, this.namespacedKey, value);
            state.update();
        }
    }

    public Optional<String> getBlockData(Block b) {
        BlockState state = b.getState();
        if (state instanceof TileState) {
            return this.getString((TileState)state, this.namespacedKey);
        }
        return Optional.empty();
    }

    public boolean isTileEntity(Material type) {
        if (type == null || !SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14)) {
            return false;
        }
        switch (type) {
            case PLAYER_HEAD: 
            case PLAYER_WALL_HEAD: 
            case CHEST: 
            case DISPENSER: 
            case BREWING_STAND: 
            case DROPPER: 
            case FURNACE: 
            case BLAST_FURNACE: 
            case HOPPER: 
            case LECTERN: 
            case JUKEBOX: 
            case ENDER_CHEST: 
            case ENCHANTING_TABLE: 
            case DAYLIGHT_DETECTOR: 
            case SMOKER: 
            case BARREL: 
            case SPAWNER: 
            case BEACON: {
                return true;
            }
        }
        return false;
    }
}

