/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.api.ErrorReport;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.ChatComponent;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.HoverEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TickerTask
implements Runnable {
    private final DecimalFormat decimalFormat = new DecimalFormat("#.##");
    private final ConcurrentMap<Location, Location> move = new ConcurrentHashMap<Location, Location>();
    private final ConcurrentMap<Location, Boolean> delete = new ConcurrentHashMap<Location, Boolean>();
    private final ConcurrentMap<Location, Long> blockTimings = new ConcurrentHashMap<Location, Long>();
    private final ConcurrentMap<String, Integer> chunkItemCount = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<String, Integer> machineCount = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<String, Long> machineTimings = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<String, Long> chunkTimings = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<Location, Integer> buggedBlocks = new ConcurrentHashMap<Location, Integer>();
    private final Set<String> chunksSkipped = new HashSet<String>();
    private final Set<BlockTicker> tickers = new HashSet<BlockTicker>();
    private boolean halted = false;
    private int skipped = 0;
    private int chunks = 0;
    private int machines = 0;
    private long time = 0L;
    private boolean running = false;

    public void abortTick() {
        this.running = false;
    }

    @Override
    public void run() {
        if (this.running) {
            return;
        }
        this.running = true;
        long timestamp = System.nanoTime();
        this.skipped = 0;
        this.chunks = 0;
        this.machines = 0;
        this.chunkItemCount.clear();
        this.machineCount.clear();
        this.time = 0L;
        this.chunkTimings.clear();
        this.chunksSkipped.clear();
        this.machineTimings.clear();
        this.blockTimings.clear();
        HashMap<Location, Integer> bugged = new HashMap<Location, Integer>(this.buggedBlocks);
        this.buggedBlocks.clear();
        HashMap<Location, Boolean> remove = new HashMap<Location, Boolean>(this.delete);
        for (Map.Entry entry : remove.entrySet()) {
            BlockStorage._integrated_removeBlockInfo((Location)entry.getKey(), (Boolean)entry.getValue());
            this.delete.remove(entry.getKey());
        }
        if (!this.halted) {
            for (String string : BlockStorage.getTickingChunks()) {
                long timestamp2 = System.nanoTime();
                ++this.chunks;
                for (Location l : BlockStorage.getTickingLocations(string)) {
                    if (l.getWorld().isChunkLoaded(l.getBlockX() >> 4, l.getBlockZ() >> 4)) {
                        Block b = l.getBlock();
                        SlimefunItem item = BlockStorage.check(l);
                        if (item != null && item.getBlockTicker() != null) {
                            ++this.machines;
                            try {
                                item.getBlockTicker().update();
                                if (item.getBlockTicker().isSynchronized()) {
                                    Slimefun.runSync(() -> {
                                        try {
                                            long timestamp3 = System.nanoTime();
                                            item.getBlockTicker().tick(b, item, BlockStorage.getLocationInfo(l));
                                            Long machinetime = (Long)this.machineTimings.get(item.getID());
                                            Integer chunk = (Integer)this.chunkItemCount.get(tickedChunk);
                                            Integer machine = (Integer)this.machineCount.get(item.getID());
                                            this.machineTimings.put(item.getID(), (machinetime != null ? machinetime : 0L) + (System.nanoTime() - timestamp3));
                                            this.chunkItemCount.put(tickedChunk, (chunk != null ? chunk : 0) + 1);
                                            this.machineCount.put(item.getID(), (machine != null ? machine : 0) + 1);
                                            this.blockTimings.put(l, System.nanoTime() - timestamp3);
                                        }
                                        catch (Exception x) {
                                            int errors = bugged.getOrDefault(l, 0);
                                            this.reportErrors(l, item, x, errors);
                                        }
                                    });
                                } else {
                                    long timestamp3 = System.nanoTime();
                                    item.getBlockTicker().tick(b, item, BlockStorage.getLocationInfo(l));
                                    this.machineTimings.merge(item.getID(), System.nanoTime() - timestamp3, Long::sum);
                                    this.chunkItemCount.merge(string, 1, Integer::sum);
                                    this.machineCount.merge(item.getID(), 1, Integer::sum);
                                    this.blockTimings.put(l, System.nanoTime() - timestamp3);
                                }
                                this.tickers.add(item.getBlockTicker());
                            }
                            catch (Exception x) {
                                int errors = bugged.getOrDefault(l, 0);
                                this.reportErrors(l, item, x, errors);
                            }
                            continue;
                        }
                        ++this.skipped;
                        continue;
                    }
                    this.skipped += BlockStorage.getTickingLocations(string).size();
                    this.chunksSkipped.add(string);
                    --this.chunks;
                    break;
                }
                this.chunkTimings.put(string, System.nanoTime() - timestamp2);
            }
        }
        for (Map.Entry entry : this.move.entrySet()) {
            BlockStorage._integrated_moveLocationInfo((Location)entry.getKey(), (Location)entry.getValue());
        }
        this.move.clear();
        Iterator<BlockTicker> iterator = this.tickers.iterator();
        while (iterator.hasNext()) {
            iterator.next().startNewTick();
            iterator.remove();
        }
        this.time = System.nanoTime() - timestamp;
        this.running = false;
    }

    private void reportErrors(Location l, SlimefunItem item, Exception x, int errors) {
        if (++errors == 1) {
            new ErrorReport((Throwable)x, l, item);
            this.buggedBlocks.put(l, errors);
        } else if (errors == 4) {
            Slimefun.getLogger().log(Level.SEVERE, "X: {0} Y: {1} Z: {2} ({3})", new Object[]{l.getBlockX(), l.getBlockY(), l.getBlockZ(), item.getID()});
            Slimefun.getLogger().log(Level.SEVERE, "has thrown 4 Exceptions in the last 4 Ticks, the Block has been terminated.");
            Slimefun.getLogger().log(Level.SEVERE, "Check your /plugins/Slimefun/error-reports/ folder for details.");
            Slimefun.getLogger().log(Level.SEVERE, " ");
            BlockStorage._integrated_removeBlockInfo(l, true);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance, () -> l.getBlock().setType(Material.AIR));
        } else {
            this.buggedBlocks.put(l, errors);
        }
    }

    public String getTime() {
        return this.toMillis(this.time, false);
    }

    public void info(CommandSender sender) {
        int hidden;
        Object builder;
        ChatComponent component;
        sender.sendMessage(ChatColors.color("&2== &aSlimefun Diagnostic Tool &2=="));
        sender.sendMessage(ChatColors.color("&6Halted: &e&l" + String.valueOf(this.halted).toUpperCase(Locale.ROOT)));
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&6Impact: &e" + this.toMillis(this.time, true)));
        sender.sendMessage(ChatColors.color("&6Ticked Chunks: &e" + this.chunks));
        sender.sendMessage(ChatColors.color("&6Ticked Machines: &e" + this.machines));
        sender.sendMessage(ChatColors.color("&6Skipped Machines: &e" + this.skipped));
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&6Ticking Machines:"));
        List timings = this.machineCount.keySet().stream().map(key -> new AbstractMap.SimpleEntry<String, Long>((String)key, this.machineTimings.getOrDefault(key, 0L))).sorted((o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue())).collect(Collectors.toList());
        if (sender instanceof Player) {
            component = new ChatComponent(ChatColors.color("   &7&oHover for more Info"));
            builder = new StringBuilder();
            hidden = 0;
            for (Map.Entry entry : timings) {
                int count = (Integer)this.machineCount.get(entry.getKey());
                if ((Long)entry.getValue() > 300000L) {
                    ((StringBuilder)builder).append("\n&c").append((String)entry.getKey()).append(" - ").append(count).append("x &7(").append(this.toMillis((Long)entry.getValue(), true)).append(", ").append(this.toMillis((Long)entry.getValue() / (long)count, true)).append(" avg/machine)");
                    continue;
                }
                ++hidden;
            }
            ((StringBuilder)builder).append("\n\n&c+ &4").append(hidden).append(" Hidden");
            component.setHoverEvent(new HoverEvent(ChatColors.color(((StringBuilder)builder).toString())));
            component.sendMessage((Player)sender);
        } else {
            int hidden2 = 0;
            for (Map.Entry entry : timings) {
                int count = (Integer)this.machineCount.get(entry.getKey());
                if ((Long)entry.getValue() > 300000L) {
                    sender.sendMessage("  " + (String)entry.getKey() + " - " + count + "x (" + this.toMillis((Long)entry.getValue(), false) + ", " + this.toMillis((Long)entry.getValue() / (long)count, false) + " avg/machine)");
                    continue;
                }
                ++hidden2;
            }
            sender.sendMessage("+ " + hidden2 + " Hidden");
        }
        sender.sendMessage("");
        sender.sendMessage(ChatColors.color("&6Ticking Chunks:"));
        timings = this.chunkTimings.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toList());
        if (sender instanceof Player) {
            component = new ChatComponent(ChatColors.color("   &7&oHover for more Info"));
            builder = new StringBuilder();
            hidden = 0;
            for (Map.Entry entry : timings) {
                if (this.chunksSkipped.contains(entry.getKey())) continue;
                if ((Long)entry.getValue() > 0L) {
                    ((StringBuilder)builder).append("\n&c").append(this.formatChunk((String)entry.getKey())).append(" - ").append(this.chunkItemCount.getOrDefault(entry.getKey(), 0)).append("x &7(").append(this.toMillis((Long)entry.getValue(), true)).append(')');
                    continue;
                }
                ++hidden;
            }
            ((StringBuilder)builder).append("\n\n&c+ &4").append(hidden).append(" Hidden");
            component.setHoverEvent(new HoverEvent(ChatColors.color(((StringBuilder)builder).toString())));
            component.sendMessage((Player)sender);
        } else {
            int hidden3 = 0;
            for (Map.Entry entry : timings) {
                if (this.chunksSkipped.contains(entry.getKey())) continue;
                if ((Long)entry.getValue() > 0L) {
                    sender.sendMessage("  " + this.formatChunk((String)entry.getKey()) + " - " + this.chunkItemCount.getOrDefault(entry.getKey(), 0) + "x (" + this.toMillis((Long)entry.getValue(), false) + ")");
                    continue;
                }
                ++hidden3;
            }
            sender.sendMessage(ChatColors.color("&c+ &4" + hidden3 + " Hidden"));
        }
    }

    private String formatChunk(String chunk) {
        String[] components = PatternUtils.SEMICOLON.split(chunk);
        return components[0] + " [" + components[2] + ',' + components[3] + ']';
    }

    public long getTimings(Block b) {
        return this.blockTimings.getOrDefault(b.getLocation(), 0L);
    }

    public long getTimings(String item) {
        return this.machineTimings.getOrDefault(item, 0L);
    }

    public long getTimings(Chunk c) {
        String id = c.getWorld().getName() + ';' + c.getX() + ';' + c.getZ();
        return this.chunkTimings.getOrDefault(id, 0L);
    }

    public void addBlockTimings(Location l, long time) {
        this.blockTimings.put(l, time);
    }

    public boolean isHalted() {
        return this.halted;
    }

    public void halt() {
        this.halted = true;
    }

    public String toMillis(long nanoseconds, boolean colors) {
        String number = this.decimalFormat.format((double)nanoseconds / 1000000.0);
        if (!colors) {
            return number;
        }
        String[] parts = PatternUtils.NUMBER_SEPERATOR.split(number);
        if (parts.length == 1) {
            return parts[0];
        }
        return parts[0] + ',' + ChatColor.GRAY + parts[1] + "ms";
    }

    public String toString() {
        return "TickerTask {\n     HALTED = " + this.halted + "\n     tickers = " + this.tickers + "\n     move = " + this.move + "\n     delete = " + this.delete + "\n     chunks = " + this.chunkItemCount + "\n     machines = " + this.machineCount + "\n     machinetime = " + this.machineTimings + "\n     chunktime = " + this.chunkTimings + "\n     skipped = " + this.chunksSkipped + "\n}";
    }

    public void queueMove(Location from, Location to) {
        this.move.put(from, to);
    }

    public void queueDelete(Location l, boolean destroy) {
        this.delete.put(l, destroy);
    }

    public void start(SlimefunPlugin plugin) {
        plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
            try {
                this.run();
            }
            catch (Throwable x) {
                plugin.getLogger().log(Level.SEVERE, x, () -> "An Exception was caught while ticking the Block Tickers Task for Slimefun v" + SlimefunPlugin.getVersion());
                this.abortTick();
            }
        }, 100L, (long)SlimefunPlugin.getCfg().getInt("URID.custom-ticker-delay"));
    }
}

