/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.miner;

import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.miner.AdvancedIndustrialMiner;
import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.miner.IndustrialMiner;
import java.util.UUID;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.BlockPosition;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import me.mrCookieSlime.Slimefun.cscorelib2.scheduling.TaskQueue;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

class ActiveMiner
implements Runnable {
    private final IndustrialMiner miner;
    private final UUID owner;
    private int fuel = 0;
    private int ores = 0;
    private boolean running = false;
    private final Block chest;
    private final Block[] pistons;
    private final BlockPosition start;
    private final BlockPosition end;
    private final int height;
    private int x;
    private int z;

    public ActiveMiner(IndustrialMiner miner, UUID owner, Block chest, Block[] pistons, Block start, Block end) {
        this.miner = miner;
        this.owner = owner;
        this.chest = chest;
        this.pistons = pistons;
        this.start = new BlockPosition(start);
        this.end = new BlockPosition(end);
        this.height = start.getY();
        this.x = start.getX();
        this.z = start.getZ();
    }

    public void start(Block b) {
        this.miner.activeMiners.put(b.getLocation(), this);
        this.running = true;
        this.warmUp();
    }

    public void stop() {
        this.running = false;
        this.miner.activeMiners.remove(this.chest.getRelative(BlockFace.DOWN).getLocation());
    }

    public void stop(String error) {
        Player p = Bukkit.getPlayer((UUID)this.owner);
        if (p != null) {
            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, error);
        }
        this.stop();
    }

    private void warmUp() {
        this.fuel = this.consumeFuel();
        if (this.fuel <= 0) {
            this.stop("machines.INDUSTRIAL_MINER.no-fuel");
            return;
        }
        TaskQueue queue = new TaskQueue();
        queue.thenRun(4, () -> this.setPistonState(this.pistons[0], true));
        queue.thenRun(10, () -> this.setPistonState(this.pistons[0], false));
        queue.thenRun(8, () -> this.setPistonState(this.pistons[1], true));
        queue.thenRun(10, () -> this.setPistonState(this.pistons[1], false));
        queue.thenRun(6, () -> this.setPistonState(this.pistons[0], true));
        queue.thenRun(9, () -> this.setPistonState(this.pistons[0], false));
        queue.thenRun(4, () -> this.setPistonState(this.pistons[1], true));
        queue.thenRun(7, () -> this.setPistonState(this.pistons[1], false));
        queue.thenRun(3, () -> this.setPistonState(this.pistons[0], true));
        queue.thenRun(5, () -> this.setPistonState(this.pistons[0], false));
        queue.thenRun(2, () -> this.setPistonState(this.pistons[1], true));
        queue.thenRun(4, () -> this.setPistonState(this.pistons[1], false));
        queue.thenRun(1, () -> this.setPistonState(this.pistons[0], true));
        queue.thenRun(3, () -> this.setPistonState(this.pistons[0], false));
        queue.thenRun(1, () -> this.setPistonState(this.pistons[1], true));
        queue.thenRun(2, () -> this.setPistonState(this.pistons[1], false));
        queue.thenRun(1, this);
        queue.execute((Plugin)SlimefunPlugin.instance);
    }

    @Override
    public void run() {
        if (!this.running) {
            return;
        }
        TaskQueue queue = new TaskQueue();
        queue.thenRun(1, () -> this.setPistonState(this.pistons[0], true));
        queue.thenRun(3, () -> this.setPistonState(this.pistons[0], false));
        queue.thenRun(1, () -> this.setPistonState(this.pistons[1], true));
        queue.thenRun(3, () -> this.setPistonState(this.pistons[1], false));
        queue.thenRun(() -> {
            try {
                Block furnace = this.chest.getRelative(BlockFace.DOWN);
                furnace.getWorld().playEffect(furnace.getLocation(), Effect.STEP_SOUND, (Object)Material.STONE);
                for (int y = this.height; y > 0; --y) {
                    Block b = this.start.getWorld().getBlockAt(this.x, y, this.z);
                    if (!SlimefunPlugin.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)this.owner), b, ProtectableAction.BREAK_BLOCK)) {
                        this.stop("machines.INDUSTRIAL_MINER.no-permission");
                        return;
                    }
                    if (!this.miner.canMine(b.getType()) || !this.push(this.miner.getOutcome(b.getType()))) continue;
                    furnace.getWorld().playEffect(furnace.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
                    furnace.getWorld().playSound(furnace.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 0.2f, 1.0f);
                    b.setType(Material.AIR);
                    --this.fuel;
                    ++this.ores;
                    Slimefun.runSync(this, 4L);
                    return;
                }
                this.nextColumn();
            }
            catch (Exception e) {
                Slimefun.getLogger().log(Level.SEVERE, e, () -> "An Error occured while running an Industrial Miner at " + new BlockPosition(this.chest));
                this.stop();
            }
        });
        queue.execute((Plugin)SlimefunPlugin.instance);
    }

    private void nextColumn() {
        if (this.x < this.end.getX()) {
            ++this.x;
        } else if (this.z < this.end.getZ()) {
            this.x = this.start.getX();
            ++this.z;
        } else {
            this.stop();
            Player p = Bukkit.getPlayer((UUID)this.owner);
            if (p != null) {
                p.playSound(p.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 0.4f, 1.0f);
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "machines.INDUSTRIAL_MINER.finished", msg -> msg.replace("%ores%", String.valueOf(this.ores)));
            }
            return;
        }
        Slimefun.runSync(this, 5L);
    }

    private boolean push(ItemStack item) {
        if (this.fuel < 1) {
            this.fuel = this.consumeFuel();
        }
        if (this.fuel > 0) {
            if (this.chest.getType() == Material.CHEST) {
                Inventory inv = ((Chest)this.chest.getState()).getBlockInventory();
                if (InvUtils.fits(inv, item, new int[0])) {
                    inv.addItem(new ItemStack[]{item});
                    return true;
                }
                this.stop("machines.INDUSTRIAL_MINER.chest-full");
            } else {
                this.stop("machines.INDUSTRIAL_MINER.destroyed");
            }
        } else {
            this.stop("machines.INDUSTRIAL_MINER.no-fuel");
        }
        return false;
    }

    private int consumeFuel() {
        if (this.chest.getType() == Material.CHEST) {
            Inventory inv = ((Chest)this.chest.getState()).getBlockInventory();
            for (int i = 0; i < inv.getSize(); ++i) {
                for (MachineFuel fuelType : this.miner.fuelTypes) {
                    ItemStack item;
                    if (!fuelType.test(item = inv.getContents()[i])) continue;
                    ItemUtils.consumeItem(item, false);
                    if (this.miner instanceof AdvancedIndustrialMiner) {
                        inv.addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
                    }
                    return fuelType.getTicks();
                }
            }
        }
        return 0;
    }

    private void setPistonState(Block block, boolean extended) {
        if (!this.running) {
            return;
        }
        try {
            Location particleLoc = this.chest.getLocation().clone().add(0.0, -1.0, 0.0);
            block.getWorld().spawnParticle(Particle.SMOKE_NORMAL, particleLoc, 20, 0.7, 0.7, 0.7, 0.0);
            if (block.getType() == Material.MOVING_PISTON) {
                block.getRelative(BlockFace.UP).setType(Material.AIR);
            } else if (block.getType() == Material.PISTON) {
                Block above = block.getRelative(BlockFace.UP);
                if (above.isEmpty() || above.getType() == Material.PISTON_HEAD) {
                    Piston piston = (Piston)block.getBlockData();
                    if (piston.getFacing() == BlockFace.UP) {
                        piston.setExtended(extended);
                        block.setBlockData((BlockData)piston, false);
                        if (extended) {
                            PistonHead head = (PistonHead)Material.PISTON_HEAD.createBlockData();
                            head.setFacing(BlockFace.UP);
                            block.getRelative(BlockFace.UP).setBlockData((BlockData)head, false);
                        } else {
                            block.getRelative(BlockFace.UP).setType(Material.AIR);
                        }
                        block.getWorld().playSound(block.getLocation(), extended ? Sound.BLOCK_PISTON_EXTEND : Sound.BLOCK_PISTON_CONTRACT, 0.1f, 1.0f);
                    } else {
                        this.stop("machines.INDUSTRIAL_MINER.piston-facing");
                    }
                } else {
                    this.stop("machines.INDUSTRIAL_MINER.piston-space");
                }
            } else {
                this.stop("machines.INDUSTRIAL_MINER.destroyed");
            }
        }
        catch (Exception e) {
            Slimefun.getLogger().log(Level.SEVERE, e, () -> "An Error occured while moving a Piston for an Industrial Miner at " + new BlockPosition(block));
            this.stop();
        }
    }
}

