/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.implementation.items.VanillaItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import org.bukkit.block.BrewingStand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class VanillaMachinesListener
implements Listener {
    public VanillaMachinesListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onGrindstone(InventoryClickEvent e) {
        ItemStack item2;
        ItemStack item1;
        MinecraftVersion minecraftVersion = SlimefunPlugin.getMinecraftVersion();
        if (!minecraftVersion.isAtLeast(MinecraftVersion.MINECRAFT_1_14)) {
            return;
        }
        if (e.getRawSlot() == 2 && e.getWhoClicked() instanceof Player && e.getInventory().getType() == InventoryType.GRINDSTONE && this.checkForUnallowedItems(item1 = e.getInventory().getContents()[0], item2 = e.getInventory().getContents()[1])) {
            e.setResult(Event.Result.DENY);
        }
    }

    @EventHandler
    public void onCraft(CraftItemEvent e) {
        for (ItemStack item : e.getInventory().getContents()) {
            SlimefunItem sfItem = SlimefunItem.getByItem(item);
            if (sfItem == null || sfItem.isUseableInWorkbench()) continue;
            e.setResult(Event.Result.DENY);
            SlimefunPlugin.getLocal().sendMessage((CommandSender)((Player)e.getWhoClicked()), "workbench.not-enhanced", true);
            break;
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent e) {
        if (e.getInventory().getResult() != null) {
            for (ItemStack item : e.getInventory().getContents()) {
                SlimefunItem sfItem = SlimefunItem.getByItem(item);
                if (sfItem == null || sfItem.isUseableInWorkbench()) continue;
                e.getInventory().setResult(null);
                break;
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onAnvil(InventoryClickEvent e) {
        ItemStack item2;
        ItemStack item1;
        if (e.getRawSlot() == 2 && e.getInventory().getType() == InventoryType.ANVIL && e.getWhoClicked() instanceof Player && this.checkForUnallowedItems(item1 = e.getInventory().getContents()[0], item2 = e.getInventory().getContents()[1])) {
            e.setResult(Event.Result.DENY);
            SlimefunPlugin.getLocal().sendMessage((CommandSender)((Player)e.getWhoClicked()), "anvil.not-working", true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPreBrew(InventoryClickEvent e) {
        Inventory inventory = e.getInventory();
        if (inventory.getType() == InventoryType.BREWING && e.getRawSlot() < inventory.getSize() && inventory.getHolder() instanceof BrewingStand) {
            e.setCancelled(this.isUnallowed(SlimefunItem.getByItem(e.getCursor())));
        }
    }

    private boolean checkForUnallowedItems(ItemStack item1, ItemStack item2) {
        if (SlimefunGuide.isGuideItem(item1) || SlimefunGuide.isGuideItem(item2)) {
            return true;
        }
        SlimefunItem sfItem1 = SlimefunItem.getByItem(item1);
        SlimefunItem sfItem2 = SlimefunItem.getByItem(item2);
        return this.isUnallowed(sfItem1) || this.isUnallowed(sfItem2);
    }

    private boolean isUnallowed(SlimefunItem item) {
        return item != null && !(item instanceof VanillaItem) && !item.isDisabled();
    }
}

