/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.geo;

import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class OilPump
extends AContainer
implements RecipeDisplayItem {
    private final GEOResource oil = SlimefunPlugin.getRegistry().getGEOResources().get(new NamespacedKey((Plugin)SlimefunPlugin.instance, "oil")).orElse(null);

    public OilPump(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        new BlockMenuPreset(this.getID(), this.getInventoryTitle()){

            @Override
            public void init() {
                OilPump.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                if (!p.hasPermission("slimefun.inventory.bypass") && !SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.ACCESS_INVENTORIES)) {
                    return false;
                }
                if (!SlimefunPlugin.getGPSNetwork().getResourceManager().getSupplies(OilPump.this.oil, b.getWorld(), b.getX() >> 4, b.getZ() >> 4).isPresent()) {
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "gps.geo.scan-required", true);
                    return false;
                }
                return true;
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return OilPump.this.getInputSlots();
                }
                return OilPump.this.getOutputSlots();
            }
        };
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return Arrays.asList(new ItemStack[]{new ItemStack(Material.BUCKET), SlimefunItems.BUCKET_OF_OIL});
    }

    @Override
    public String getMachineIdentifier() {
        return "OIL_PUMP";
    }

    @Override
    public String getInventoryTitle() {
        return "&4Oil Pump";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.DIAMOND_SHOVEL);
    }

    @Override
    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory(b);
        if (this.isProcessing(b)) {
            int timeleft = (Integer)progress.get(b);
            if (timeleft > 0) {
                ChestMenuUtils.updateProgressbar(inv, 22, timeleft, ((MachineRecipe)processing.get(b)).getTicks(), this.getProgressBar());
                if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                    return;
                }
                ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                progress.put(b, timeleft - 1);
            } else {
                inv.replaceExistingItem(22, new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
                inv.pushItem(SlimefunItems.BUCKET_OF_OIL, this.getOutputSlots());
                progress.remove(b);
                processing.remove(b);
            }
        } else if (inv.fits(SlimefunItems.BUCKET_OF_OIL, this.getOutputSlots())) {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunUtils.isItemSimilar(inv.getItemInSlot(slot), new ItemStack(Material.BUCKET), true)) continue;
                OptionalInt supplies = SlimefunPlugin.getGPSNetwork().getResourceManager().getSupplies(this.oil, b.getWorld(), b.getX() >> 4, b.getZ() >> 4);
                if (supplies.isPresent() && supplies.getAsInt() > 0) {
                    MachineRecipe r = new MachineRecipe(26, new ItemStack[0], new ItemStack[]{SlimefunItems.BUCKET_OF_OIL});
                    inv.consumeItem(slot);
                    processing.put(b, r);
                    progress.put(b, r.getTicks());
                    SlimefunPlugin.getGPSNetwork().getResourceManager().setSupplies(this.oil, b.getWorld(), b.getX() >> 4, b.getZ() >> 4, supplies.getAsInt() - 1);
                    break;
                }
                ItemStack item = inv.getItemInSlot(slot).clone();
                inv.replaceExistingItem(slot, null);
                inv.pushItem(item, this.getOutputSlots());
                break;
            }
        }
    }
}

