/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ProgrammableAndroid;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;

public abstract class FarmerAndroid
extends ProgrammableAndroid {
    public FarmerAndroid(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public AndroidType getAndroidType() {
        return AndroidType.FARMER;
    }

    private boolean isFullGrown(Block block) {
        if (!(block.getBlockData() instanceof Ageable)) {
            return false;
        }
        Ageable ageable = (Ageable)block.getBlockData();
        return ageable.getAge() >= ageable.getMaximumAge();
    }

    @Override
    protected void farm(BlockMenu menu, Block block) {
        ItemStack drop;
        if (this.isFullGrown(block) && (drop = this.getDropFromCrop(block.getType())) != null && menu.fits(drop, this.getOutputSlots())) {
            menu.pushItem(drop, this.getOutputSlots());
            Ageable ageable = (Ageable)block.getBlockData();
            ageable.setAge(0);
            block.setBlockData((BlockData)ageable);
            block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
        }
    }

    private ItemStack getDropFromCrop(Material crop) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14) && crop == Material.SWEET_BERRY_BUSH) {
            return new ItemStack(Material.SWEET_BERRIES, ((Random)random).nextInt(3) + 1);
        }
        switch (crop) {
            case WHEAT: {
                return new ItemStack(Material.WHEAT, ((Random)random).nextInt(2) + 1);
            }
            case POTATOES: {
                return new ItemStack(Material.POTATO, ((Random)random).nextInt(3) + 1);
            }
            case CARROTS: {
                return new ItemStack(Material.CARROT, ((Random)random).nextInt(3) + 1);
            }
            case BEETROOTS: {
                return new ItemStack(Material.BEETROOT, ((Random)random).nextInt(3) + 1);
            }
            case COCOA: {
                return new ItemStack(Material.COCOA_BEANS, ((Random)random).nextInt(3) + 1);
            }
            case NETHER_WART: {
                return new ItemStack(Material.NETHER_WART, ((Random)random).nextInt(3) + 1);
            }
        }
        return null;
    }
}

