/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces;

import java.util.function.Consumer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public interface InventoryBlock {
    public int[] getInputSlots();

    public int[] getOutputSlots();

    default public void createPreset(SlimefunItem item, Consumer<BlockMenuPreset> setup) {
        this.createPreset(item, item.getItemName(), setup);
    }

    default public void createPreset(final SlimefunItem item, String title, final Consumer<BlockMenuPreset> setup) {
        new BlockMenuPreset(item.getID(), title){

            @Override
            public void init() {
                setup.accept(this);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return InventoryBlock.this.getInputSlots();
                }
                return InventoryBlock.this.getOutputSlots();
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.ACCESS_INVENTORIES) && Slimefun.hasUnlocked(p, item, false);
            }
        };
    }
}

