/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.api.network.NetworkComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoUtils;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ChestTerminalNetwork;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemStackAndInteger;
import io.github.thebusybiscuit.slimefun4.utils.holograms.SimpleHologram;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CargoNet
extends ChestTerminalNetwork {
    private static final int RANGE = 5;
    private static final int TICK_DELAY = SlimefunPlugin.getCfg().getInt("networks.cargo-ticker-delay");
    private final Set<Location> inputNodes = new HashSet<Location>();
    private final Set<Location> outputNodes = new HashSet<Location>();
    private final Map<Location, Integer> roundRobin = new HashMap<Location, Integer>();
    private int tickDelayThreshold = 0;

    public static CargoNet getNetworkFromLocation(Location l) {
        return SlimefunPlugin.getNetworkManager().getNetworkFromLocation(l, CargoNet.class).orElse(null);
    }

    public static CargoNet getNetworkFromLocationOrCreate(Location l) {
        Optional<CargoNet> cargoNetwork = SlimefunPlugin.getNetworkManager().getNetworkFromLocation(l, CargoNet.class);
        if (cargoNetwork.isPresent()) {
            return cargoNetwork.get();
        }
        CargoNet network = new CargoNet(l);
        SlimefunPlugin.getNetworkManager().registerNetwork(network);
        return network;
    }

    protected CargoNet(Location l) {
        super(l);
    }

    @Override
    public int getRange() {
        return 5;
    }

    @Override
    public NetworkComponent classifyLocation(Location l) {
        String id = BlockStorage.checkID(l);
        if (id == null) {
            return null;
        }
        switch (id) {
            case "CARGO_MANAGER": {
                return NetworkComponent.REGULATOR;
            }
            case "CARGO_NODE": {
                return NetworkComponent.CONNECTOR;
            }
            case "CARGO_NODE_INPUT": 
            case "CARGO_NODE_OUTPUT": 
            case "CARGO_NODE_OUTPUT_ADVANCED": 
            case "CT_IMPORT_BUS": 
            case "CT_EXPORT_BUS": 
            case "CHEST_TERMINAL": {
                return NetworkComponent.TERMINUS;
            }
        }
        return null;
    }

    @Override
    public void onClassificationChange(Location l, NetworkComponent from, NetworkComponent to) {
        if (from == NetworkComponent.TERMINUS) {
            this.inputNodes.remove(l);
            this.outputNodes.remove(l);
            this.terminals.remove(l);
            this.imports.remove(l);
            this.exports.remove(l);
        }
        if (to == NetworkComponent.TERMINUS) {
            switch (BlockStorage.checkID(l)) {
                case "CARGO_NODE_INPUT": {
                    this.inputNodes.add(l);
                    break;
                }
                case "CARGO_NODE_OUTPUT": 
                case "CARGO_NODE_OUTPUT_ADVANCED": {
                    this.outputNodes.add(l);
                    break;
                }
                case "CHEST_TERMINAL": {
                    this.terminals.add(l);
                    break;
                }
                case "CT_IMPORT_BUS": {
                    this.imports.add(l);
                    break;
                }
                case "CT_EXPORT_BUS": {
                    this.exports.add(l);
                    break;
                }
            }
        }
    }

    public void tick(Block b) {
        if (!this.regulator.equals((Object)b.getLocation())) {
            SimpleHologram.update(b, "&4Multiple Cargo Regulators connected");
            return;
        }
        super.tick();
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            SimpleHologram.update(b, "&cNo Cargo Nodes found");
        } else {
            SimpleHologram.update(b, "&7Status: &a&lONLINE");
            Map<Integer, List<Location>> output = this.mapOutputNodes();
            HashSet<Location> destinations = new HashSet<Location>();
            List<Location> output16 = output.get(16);
            if (output16 != null) {
                destinations.addAll(output16);
            }
            Slimefun.runSync(() -> this.run(b, destinations, output));
        }
    }

    private Map<Integer, List<Location>> mapOutputNodes() {
        HashMap<Integer, List<Location>> output = new HashMap<Integer, List<Location>>();
        LinkedList<Location> list = new LinkedList<Location>();
        int lastFrequency = -1;
        for (Location outputNode : this.outputNodes) {
            int frequency = CargoNet.getFrequency(outputNode);
            if (frequency != lastFrequency && lastFrequency != -1) {
                output.merge(lastFrequency, list, (prev, next) -> {
                    prev.addAll(next);
                    return prev;
                });
                list = new LinkedList();
            }
            list.add(outputNode);
            lastFrequency = frequency;
        }
        if (!list.isEmpty()) {
            output.merge(lastFrequency, list, (prev, next) -> {
                prev.addAll(next);
                return prev;
            });
        }
        return output;
    }

    private void run(Block b, Set<Location> destinations, Map<Integer, List<Location>> output) {
        if (BlockStorage.getLocationInfo(b.getLocation(), "visualizer") == null) {
            this.display();
        }
        if (this.tickDelayThreshold < TICK_DELAY) {
            ++this.tickDelayThreshold;
            return;
        }
        this.tickDelayThreshold = 0;
        HashMap<Location, Integer> inputs = new HashMap<Location, Integer>();
        HashSet<Location> providers = new HashSet<Location>();
        for (Location location : this.inputNodes) {
            int frequency = CargoNet.getFrequency(location);
            if (frequency == 16) {
                providers.add(location);
                continue;
            }
            if (frequency < 0 || frequency >= 16) continue;
            inputs.put(location, frequency);
        }
        if (SlimefunPlugin.getThirdPartySupportService().isChestTerminalInstalled()) {
            this.handleItemRequests(providers, destinations);
        }
        for (Map.Entry entry : inputs.entrySet()) {
            Location input = (Location)entry.getKey();
            Optional<Block> attachedBlock = CargoNet.getAttachedBlock(input.getBlock());
            if (!attachedBlock.isPresent()) continue;
            this.routeItems(input, attachedBlock.get(), (Integer)entry.getValue(), output);
        }
        if (SlimefunPlugin.getThirdPartySupportService().isChestTerminalInstalled()) {
            this.updateTerminals(providers);
        }
    }

    private void routeItems(Location inputNode, Block inputTarget, int frequency, Map<Integer, List<Location>> outputNodes) {
        BlockState state;
        DirtyChestMenu menu;
        Config cfg = BlockStorage.getLocationInfo(inputNode);
        boolean roundrobin = "true".equals(cfg.getString("round-robin"));
        ItemStackAndInteger slot = CargoUtils.withdraw(inputNode.getBlock(), inputTarget, Integer.parseInt(cfg.getString("index")));
        if (slot == null) {
            return;
        }
        ItemStack stack = slot.getItem();
        int previousSlot = slot.getInt();
        List<Location> outputs = outputNodes.get(frequency);
        if (outputs != null) {
            Location output;
            Optional<Block> target;
            LinkedList<Location> outputList = new LinkedList<Location>(outputs);
            if (roundrobin) {
                this.roundRobinSort(inputNode, outputList);
            }
            Iterator iterator = outputList.iterator();
            while (iterator.hasNext() && (!(target = CargoNet.getAttachedBlock((output = (Location)iterator.next()).getBlock())).isPresent() || (stack = CargoUtils.insert(output.getBlock(), target.get(), stack, -1)) != null)) {
            }
        }
        if ((menu = CargoUtils.getChestMenu(inputTarget)) != null) {
            menu.replaceExistingItem(previousSlot, stack);
        } else if (CargoUtils.hasInventory(inputTarget) && (state = inputTarget.getState()) instanceof InventoryHolder) {
            Inventory inv = ((InventoryHolder)state).getInventory();
            inv.setItem(previousSlot, stack);
        }
    }

    private void roundRobinSort(Location input, List<Location> outputs) {
        int index = this.roundRobin.getOrDefault(input, 0);
        if (index < outputs.size()) {
            for (int i = 0; i < index; ++i) {
                Location temp = outputs.remove(0);
                outputs.add(temp);
            }
            ++index;
        } else {
            index = 1;
        }
        this.roundRobin.put(input, index);
    }

    private static int getFrequency(Location l) {
        try {
            String str = BlockStorage.getLocationInfo(l).getString("frequency");
            return Integer.parseInt(str);
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.SEVERE, x, () -> "An Error occurred while parsing a Cargo Node Frequency (" + l.getWorld().getName() + " - " + l.getBlockX() + "," + l.getBlockY() + "," + l.getBlockZ() + ")");
            return 0;
        }
    }
}

