/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.OreWasher;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public abstract class ElectricDustWasher
extends AContainer {
    private OreWasher oreWasher;
    private final boolean legacyMode = SlimefunPlugin.getCfg().getBoolean("options.legacy-dust-washer");

    public ElectricDustWasher(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public void preRegister() {
        super.preRegister();
        this.oreWasher = (OreWasher)SlimefunItems.ORE_WASHER.getItem();
    }

    @Override
    public String getInventoryTitle() {
        return "&bElectric Dust Washer";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.GOLDEN_SHOVEL);
    }

    @Override
    public abstract int getSpeed();

    @Override
    protected void tick(Block b) {
        block7: {
            BlockMenu menu;
            block5: {
                block6: {
                    menu = BlockStorage.getInventory(b);
                    if (!this.isProcessing(b)) break block5;
                    int timeleft = (Integer)progress.get(b);
                    if (timeleft <= 0 || this.getSpeed() >= 10) break block6;
                    ChestMenuUtils.updateProgressbar(menu, 22, timeleft, ((MachineRecipe)processing.get(b)).getTicks(), this.getProgressBar());
                    if (ChargableBlock.isChargable(b)) {
                        if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                            return;
                        }
                        ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                        progress.put(b, timeleft - 1);
                    } else {
                        progress.put(b, timeleft - 1);
                    }
                    break block7;
                }
                if (!ChargableBlock.isChargable(b)) break block7;
                if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                    return;
                }
                ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                menu.replaceExistingItem(22, new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ", new String[0]));
                menu.pushItem(((MachineRecipe)processing.get(b)).getOutput()[0].clone(), this.getOutputSlots());
                progress.remove(b);
                processing.remove(b);
                break block7;
            }
            for (int slot : this.getInputSlots()) {
                if (this.process(b, menu, slot)) break;
            }
        }
    }

    private boolean process(Block b, BlockMenu menu, int slot) {
        if (SlimefunUtils.isItemSimilar(menu.getItemInSlot(slot), SlimefunItems.SIFTED_ORE, true)) {
            if (!this.legacyMode) {
                boolean emptySlot = false;
                for (int outputSlot : this.getOutputSlots()) {
                    if (menu.getItemInSlot(outputSlot) != null) continue;
                    emptySlot = true;
                    break;
                }
                if (!emptySlot) {
                    return true;
                }
            }
            ItemStack adding = this.oreWasher.getRandomDust();
            MachineRecipe r = new MachineRecipe(4 / this.getSpeed(), new ItemStack[0], new ItemStack[]{adding});
            if (!this.legacyMode || menu.fits(r.getOutput()[0], this.getOutputSlots())) {
                menu.consumeItem(slot);
                processing.put(b, r);
                progress.put(b, r.getTicks());
            }
            return true;
        }
        if (SlimefunUtils.isItemSimilar(menu.getItemInSlot(slot), SlimefunItems.PULVERIZED_ORE, true)) {
            MachineRecipe r = new MachineRecipe(4 / this.getSpeed(), new ItemStack[0], new ItemStack[]{SlimefunItems.PURE_ORE_CLUSTER});
            if (menu.fits(r.getOutput()[0], this.getOutputSlots())) {
                menu.consumeItem(slot);
                processing.put(b, r);
                progress.put(b, r.getTicks());
            }
            return true;
        }
        return false;
    }

    @Override
    public String getMachineIdentifier() {
        return "ELECTRIC_DUST_WASHER";
    }
}

