/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideLayout;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SlimefunGuideListener
implements Listener {
    private final boolean giveOnFirstJoin;

    public SlimefunGuideListener(SlimefunPlugin plugin, boolean giveOnFirstJoin) {
        this.giveOnFirstJoin = giveOnFirstJoin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        if (this.giveOnFirstJoin && !e.getPlayer().hasPlayedBefore()) {
            Player p = e.getPlayer();
            if (!SlimefunPlugin.getWorldSettingsService().isWorldEnabled(p.getWorld())) {
                return;
            }
            SlimefunGuideLayout type = SlimefunPlugin.getCfg().getBoolean("guide.default-view-book") ? SlimefunGuideLayout.BOOK : SlimefunGuideLayout.CHEST;
            p.getInventory().addItem(new ItemStack[]{SlimefunGuide.getItem(type)});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInteract(PlayerRightClickEvent e) {
        Player p = e.getPlayer();
        if (this.openGuide(e, SlimefunGuideLayout.BOOK) == Event.Result.ALLOW) {
            if (p.isSneaking()) {
                SlimefunGuideSettings.openSettings(p, e.getItem());
            } else {
                SlimefunGuide.openGuide(p, SlimefunGuideLayout.BOOK);
            }
        } else if (this.openGuide(e, SlimefunGuideLayout.CHEST) == Event.Result.ALLOW) {
            if (p.isSneaking()) {
                SlimefunGuideSettings.openSettings(p, e.getItem());
            } else {
                SlimefunGuide.openGuide(p, SlimefunGuideLayout.CHEST);
            }
        } else if (this.openGuide(e, SlimefunGuideLayout.CHEAT_SHEET) == Event.Result.ALLOW) {
            p.chat("/sf cheat");
        }
    }

    private Event.Result openGuide(PlayerRightClickEvent e, SlimefunGuideLayout layout) {
        Player p = e.getPlayer();
        ItemStack item = e.getItem();
        if (SlimefunUtils.isItemSimilar(item, SlimefunGuide.getItem(layout), true)) {
            e.cancel();
            if (!SlimefunPlugin.getWorldSettingsService().isWorldEnabled(p.getWorld())) {
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.disabled-item", true);
                return Event.Result.DENY;
            }
            return Event.Result.ALLOW;
        }
        return Event.Result.DEFAULT;
    }
}

