/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.api.SlimefunBranch;
import java.io.File;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.Updater;
import org.bukkit.plugin.Plugin;

public class UpdaterService {
    private final SlimefunPlugin plugin;
    private final Updater updater;
    private final SlimefunBranch branch;

    public UpdaterService(SlimefunPlugin plugin, File file) {
        this.plugin = plugin;
        String version = plugin.getDescription().getVersion();
        if (version.contains("UNOFFICIAL")) {
            this.updater = null;
            this.branch = SlimefunBranch.UNOFFICIAL;
        } else if (version.startsWith("DEV - ")) {
            this.updater = new GitHubBuildsUpdater((Plugin)plugin, file, "TheBusyBiscuit/Slimefun4/master");
            this.branch = SlimefunBranch.DEVELOPMENT;
        } else if (version.startsWith("RC - ")) {
            this.updater = new GitHubBuildsUpdater((Plugin)plugin, file, "TheBusyBiscuit/Slimefun4/stable", "RC - ");
            this.branch = SlimefunBranch.STABLE;
        } else {
            this.updater = null;
            this.branch = SlimefunBranch.UNKNOWN;
        }
    }

    public SlimefunBranch getBranch() {
        return this.branch;
    }

    public void start() {
        if (this.updater != null) {
            this.updater.start();
        } else {
            this.printBorder();
            this.plugin.getLogger().log(Level.WARNING, "It looks like you are using an unofficially modified build of Slimefun!");
            this.plugin.getLogger().log(Level.WARNING, "Auto-Updates have been disabled, this build is not considered safe.");
            this.plugin.getLogger().log(Level.WARNING, "Do not report bugs encountered in this Version of Slimefun to any official sources.");
            this.printBorder();
        }
    }

    public void disable() {
        this.printBorder();
        this.plugin.getLogger().log(Level.WARNING, "It looks like you have disabled auto-updates for Slimefun!");
        this.plugin.getLogger().log(Level.WARNING, "Auto-Updates keep your server safe, performant and bug-free.");
        this.plugin.getLogger().log(Level.WARNING, "We respect your decision.");
        if (this.branch != SlimefunBranch.STABLE) {
            this.plugin.getLogger().log(Level.WARNING, "If you are just scared of Slimefun breaking, then please consider using a \"stable\" build instead of disabling auto-updates.");
        }
        this.printBorder();
    }

    private void printBorder() {
        this.plugin.getLogger().log(Level.WARNING, "#######################################################");
    }
}

