/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api;

public enum MinecraftVersion {
    MINECRAFT_1_13("1.13.x"),
    MINECRAFT_1_14("1.14.x"),
    MINECRAFT_1_15("1.15.x"),
    UNKNOWN("Unknown");

    private final String name;
    private final String prefix;

    private MinecraftVersion(String name) {
        this.name = name;
        this.prefix = this.name().replace("MINECRAFT_", "v") + '_';
    }

    public String getName() {
        return this.name;
    }

    public boolean matches(String version) {
        return version.startsWith(this.prefix);
    }

    public boolean isAtLeast(MinecraftVersion version) {
        if (this == UNKNOWN) {
            return false;
        }
        return this.ordinal() >= version.ordinal();
    }
}

