/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.handlers;

import io.github.thebusybiscuit.slimefun4.api.exceptions.IncompatibleItemHandlerException;
import java.util.Optional;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.NotPlaceable;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import org.bukkit.block.Block;

public abstract class BlockTicker
implements ItemHandler {
    protected boolean unique = true;

    public void update() {
        if (this.unique) {
            this.uniqueTick();
            this.unique = false;
        }
    }

    @Override
    public Optional<IncompatibleItemHandlerException> validate(SlimefunItem item) {
        if (!item.getItem().getType().isBlock()) {
            return Optional.of(new IncompatibleItemHandlerException("Only Materials that are blocks can have a BlockTicker.", item, this));
        }
        if (item instanceof NotPlaceable) {
            return Optional.of(new IncompatibleItemHandlerException("Only Slimefun items that are not marked as 'NotPlaceable' can have a BlockTicker.", item, this));
        }
        return Optional.empty();
    }

    public abstract boolean isSynchronized();

    public abstract void tick(Block var1, SlimefunItem var2, Config var3);

    public void uniqueTick() {
    }

    @Override
    public Class<? extends ItemHandler> getIdentifier() {
        return BlockTicker.class;
    }

    public void startNewTick() {
        this.unique = true;
    }
}

