/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.items.weapons.SlimefunBow;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BowShootHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.plugin.Plugin;

public class SlimefunBowListener
implements Listener {
    private final Map<UUID, SlimefunBow> bows = new HashMap<UUID, SlimefunBow>();

    public SlimefunBowListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public Map<UUID, SlimefunBow> getBows() {
        return this.bows;
    }

    @EventHandler
    public void onBowUse(EntityShootBowEvent e) {
        SlimefunItem bow;
        if (e.getEntity() instanceof Player && e.getProjectile() instanceof Arrow && (bow = SlimefunItem.getByItem(e.getBow())) instanceof SlimefunBow) {
            this.bows.put(e.getProjectile().getUniqueId(), (SlimefunBow)bow);
        }
    }

    @EventHandler
    public void onArrowHit(ProjectileHitEvent e) {
        Slimefun.runSync(() -> {
            if (e.getEntity().isValid() && e.getEntity() instanceof Arrow) {
                this.bows.remove(e.getEntity().getUniqueId());
            }
        }, 4L);
    }

    @EventHandler
    public void onArrowSuccessfulHit(EntityDamageByEntityEvent e) {
        if (e.getDamager() instanceof Arrow && e.getEntity() instanceof LivingEntity) {
            SlimefunBow bow = this.bows.get(e.getDamager().getUniqueId());
            if (bow != null) {
                bow.callItemHandler(BowShootHandler.class, handler -> handler.onHit(e, (LivingEntity)e.getEntity()));
            }
            this.bows.remove(e.getDamager().getUniqueId());
        }
    }
}

