/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems;

import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.GeneratorTicker;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

abstract class AbstractEnergyGenerator
extends SlimefunItem
implements InventoryBlock,
RecipeDisplayItem,
EnergyNetComponent {
    protected final Set<MachineFuel> fuelTypes = new HashSet<MachineFuel>();

    protected AbstractEnergyGenerator(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    public abstract String getInventoryTitle();

    public abstract ItemStack getProgressBar();

    public abstract int getEnergyProduction();

    protected abstract void registerDefaultFuelTypes();

    @Override
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.GENERATOR;
    }

    protected abstract GeneratorTicker onTick();

    @Override
    public void preRegister() {
        super.preRegister();
        this.addItemHandler(this.onTick());
    }

    public void registerFuel(MachineFuel fuel) {
        this.fuelTypes.add(fuel);
    }

    public Set<MachineFuel> getFuelTypes() {
        return this.fuelTypes;
    }

    @Override
    public String getLabelLocalPath() {
        return "guide.tooltips.recipes.generator";
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (MachineFuel fuel : this.fuelTypes) {
            ItemStack item = fuel.getInput().clone();
            ItemMeta im = item.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u21e8 &7Lasts " + NumberUtils.getTimeLeft(fuel.getTicks() / 2))));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u21e8 &e\u26a1 &7" + this.getEnergyProduction() * 2)) + " J/s");
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u21e8 &e\u26a1 &7" + DoubleHandler.getFancyDouble((double)fuel.getTicks() * (double)this.getEnergyProduction()) + " J in total")));
            im.setLore(lore);
            item.setItemMeta(im);
            list.add(item);
        }
        return list;
    }
}

