/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.core.attributes.Soulbound;
import java.util.List;
import java.util.Optional;
import me.mrCookieSlime.EmeraldEnchants.EmeraldEnchants;
import me.mrCookieSlime.EmeraldEnchants.ItemEnchantment;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.item.ImmutableItemMeta;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class SlimefunUtils {
    private static final String EMERALDENCHANTS_LORE = ChatColor.YELLOW.toString() + ChatColor.YELLOW.toString() + ChatColor.GRAY.toString();
    private static final String SOULBOUND_LORE = ChatColor.GRAY + "Soulbound";
    private static final String NO_PICKUP_METADATA = "no_pickup";

    private SlimefunUtils() {
    }

    public static boolean hasNoPickupFlag(Item item) {
        return item.hasMetadata(NO_PICKUP_METADATA);
    }

    public static void markAsNoPickup(Item item, String context) {
        item.setMetadata(NO_PICKUP_METADATA, (MetadataValue)new FixedMetadataValue((Plugin)SlimefunPlugin.instance, (Object)context));
    }

    public static boolean isSoulbound(ItemStack item) {
        SlimefunItem sfItem;
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        SlimefunItem backpack = SlimefunItems.BOUND_BACKPACK.getItem();
        if (backpack != null && backpack.isItem(item)) {
            return !backpack.isDisabled();
        }
        ItemStack strippedItem = item.clone();
        if (SlimefunPlugin.getThirdPartySupportService().isEmeraldEnchantsInstalled()) {
            for (ItemEnchantment enchantment : EmeraldEnchants.getInstance().getRegistry().getEnchantments(item)) {
                EmeraldEnchants.getInstance().getRegistry().applyEnchantment(strippedItem, enchantment.getEnchantment(), 0);
            }
        }
        if ((sfItem = SlimefunItem.getByItem(strippedItem)) instanceof Soulbound && !sfItem.isDisabled()) {
            return true;
        }
        if (item.hasItemMeta()) {
            ItemMeta im = item.getItemMeta();
            return im.hasLore() && im.getLore().contains(SOULBOUND_LORE);
        }
        return false;
    }

    public static boolean containsSimilarItem(Inventory inventory, ItemStack itemStack, boolean checkLore) {
        if (inventory == null || itemStack == null) {
            return false;
        }
        for (ItemStack is : inventory.getStorageContents()) {
            if (is == null || is.getType() == Material.AIR || !SlimefunUtils.isItemSimilar(is, itemStack, checkLore)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemSimilar(ItemStack item, ItemStack sfitem, boolean checkLore) {
        if (item == null) {
            return sfitem == null;
        }
        if (sfitem == null) {
            return false;
        }
        if (item instanceof SlimefunItemStack && sfitem instanceof SlimefunItemStack) {
            return ((SlimefunItemStack)item).getItemID().equals(((SlimefunItemStack)sfitem).getItemID());
        }
        if (item.getType() == sfitem.getType() && item.getAmount() >= sfitem.getAmount()) {
            if (!item.hasItemMeta() && !sfitem.hasItemMeta()) {
                return true;
            }
            ItemMeta itemMeta = item.getItemMeta();
            if (sfitem instanceof SlimefunItemStack) {
                Optional<String> id = SlimefunPlugin.getItemDataService().getItemData(itemMeta);
                if (id.isPresent()) {
                    return id.get().equals(((SlimefunItemStack)sfitem).getItemID());
                }
                ImmutableItemMeta meta = ((SlimefunItemStack)sfitem).getImmutableMeta();
                return SlimefunUtils.equalsItemMeta(itemMeta, meta, checkLore);
            }
            ItemMeta sfitemMeta = sfitem.getItemMeta();
            return SlimefunUtils.equalsItemMeta(itemMeta, sfitemMeta, checkLore);
        }
        return false;
    }

    private static boolean equalsItemMeta(ItemMeta itemMeta, ImmutableItemMeta meta, boolean checkLore) {
        Optional<String> displayName = meta.getDisplayName();
        if (itemMeta.hasDisplayName() && displayName.isPresent()) {
            if (itemMeta.getDisplayName().equals(displayName.get())) {
                Optional<List<String>> itemLore = meta.getLore();
                if (checkLore) {
                    if (itemMeta.hasLore() && itemLore.isPresent()) {
                        return SlimefunUtils.equalsLore(itemMeta.getLore(), itemLore.get());
                    }
                    return !itemMeta.hasLore() && !itemLore.isPresent();
                }
                return true;
            }
            return false;
        }
        if (!itemMeta.hasDisplayName() && !displayName.isPresent()) {
            Optional<List<String>> itemLore = meta.getLore();
            if (checkLore) {
                if (itemMeta.hasLore() && itemLore.isPresent()) {
                    return SlimefunUtils.equalsLore(itemMeta.getLore(), itemLore.get());
                }
                return !itemMeta.hasLore() && !itemLore.isPresent();
            }
            return true;
        }
        return false;
    }

    private static boolean equalsItemMeta(ItemMeta itemMeta, ItemMeta sfitemMeta, boolean checkLore) {
        if (itemMeta.hasDisplayName() && sfitemMeta.hasDisplayName()) {
            if (itemMeta.getDisplayName().equals(sfitemMeta.getDisplayName())) {
                if (checkLore) {
                    if (itemMeta.hasLore() && sfitemMeta.hasLore()) {
                        return SlimefunUtils.equalsLore(itemMeta.getLore(), sfitemMeta.getLore());
                    }
                    return !itemMeta.hasLore() && !sfitemMeta.hasLore();
                }
                return true;
            }
            return false;
        }
        if (!itemMeta.hasDisplayName() && !sfitemMeta.hasDisplayName()) {
            if (checkLore) {
                if (itemMeta.hasLore() && sfitemMeta.hasLore()) {
                    return SlimefunUtils.equalsLore(itemMeta.getLore(), sfitemMeta.getLore());
                }
                return !itemMeta.hasLore() && !sfitemMeta.hasLore();
            }
            return true;
        }
        return false;
    }

    private static boolean equalsLore(List<String> lore, List<String> lore2) {
        StringBuilder string1 = new StringBuilder();
        StringBuilder string2 = new StringBuilder();
        for (String string : lore) {
            if (string.equals(SOULBOUND_LORE) || string.startsWith(EMERALDENCHANTS_LORE)) continue;
            string1.append("-NEW LINE-").append(string);
        }
        for (String string : lore2) {
            if (string.equals(SOULBOUND_LORE) || string.startsWith(EMERALDENCHANTS_LORE)) continue;
            string2.append("-NEW LINE-").append(string);
        }
        return string1.toString().equals(string2.toString());
    }
}

