/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.chat.json;

import com.google.gson.JsonObject;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatInput;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.IChatInput;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.ClickEventAction;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ClickEvent {
    private final JsonObject json;

    public ClickEvent(@NonNull ClickEventAction action, @NonNull String value) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.json = new JsonObject();
        this.json.addProperty("action", action.toString());
        this.json.addProperty("value", value);
    }

    public ClickEvent(int bookPage) {
        this.json = new JsonObject();
        this.json.addProperty("action", "change_page");
        this.json.addProperty("value", String.valueOf(bookPage));
    }

    public ClickEvent(@NonNull Plugin plugin, @NonNull Player p, @NonNull Consumer<Player> callback) {
        this(plugin, p, -1, callback);
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
    }

    public ClickEvent(@NonNull Plugin plugin, @NonNull Player p, final int minutesValid, final @NonNull Consumer<Player> callback) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        this.json = new JsonObject();
        this.json.addProperty("action", "run_command");
        final long timestamp = System.nanoTime();
        final String command = " -- cs-corelib json_text_click -- " + timestamp;
        this.json.addProperty("value", command);
        ChatInput.queue(plugin, p, new IChatInput(){

            @Override
            public boolean isExpired() {
                if (minutesValid == -1) {
                    return false;
                }
                return System.nanoTime() >= timestamp + TimeUnit.NANOSECONDS.convert(minutesValid, TimeUnit.MINUTES);
            }

            @Override
            public boolean test(String text) {
                return text.equals(command);
            }

            @Override
            public void onChat(Player p, String msg) {
                callback.accept(p);
            }
        });
    }

    public JsonObject asJson() {
        return this.json;
    }
}

