/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.NotPlaceable;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockBreakHandler;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemUseHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.Vein;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollections;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Axis;
import org.bukkit.Effect;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class LumberAxe
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable {
    public LumberAxe(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public void preRegister() {
        super.preRegister();
        this.addItemHandler(new BlockBreakHandler(){

            @Override
            public boolean isPrivate() {
                return false;
            }

            @Override
            public boolean onBlockBreak(BlockBreakEvent e, ItemStack item, int fortune, List<ItemStack> drops) {
                if (MaterialCollections.getAllLogs().contains(e.getBlock().getType()) && LumberAxe.this.isItem(item)) {
                    if (!Slimefun.hasUnlocked(e.getPlayer(), LumberAxe.this, true)) {
                        return true;
                    }
                    List<Block> logs = Vein.find(e.getBlock(), 100, b -> MaterialCollections.getAllLogs().contains(b.getType()));
                    if (logs.contains(e.getBlock())) {
                        logs.remove(e.getBlock());
                    }
                    for (Block b2 : logs) {
                        if (!SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b2, ProtectableAction.BREAK_BLOCK)) continue;
                        b2.getWorld().playEffect(b2.getLocation(), Effect.STEP_SOUND, (Object)b2.getType());
                        for (ItemStack drop : b2.getDrops(LumberAxe.this.getItem())) {
                            b2.getWorld().dropItemNaturally(b2.getLocation(), drop);
                        }
                        b2.setType(Material.AIR);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public ItemUseHandler getItemHandler() {
        return e -> {
            Block block;
            if (e.getClickedBlock().isPresent() && this.isUnstrippedLog(block = e.getClickedBlock().get())) {
                List<Block> logs = Vein.find(block, 20, this::isUnstrippedLog);
                if (logs.contains(block)) {
                    logs.remove(block);
                }
                for (Block b : logs) {
                    Material type = b.getType();
                    if (!SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b, ProtectableAction.BREAK_BLOCK)) continue;
                    b.getWorld().playSound(b.getLocation(), Sound.ITEM_AXE_STRIP, 1.0f, 1.0f);
                    Axis axis = ((Orientable)b.getBlockData()).getAxis();
                    b.setType(Material.valueOf((String)("STRIPPED_" + type.name())));
                    Orientable orientable = (Orientable)b.getBlockData();
                    orientable.setAxis(axis);
                    b.setBlockData((BlockData)orientable);
                }
            }
        };
    }

    private boolean isUnstrippedLog(Block block) {
        return Tag.LOGS.isTagged((Keyed)block.getType()) && !block.getType().name().startsWith("STRIPPED_");
    }
}

