/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.NotPlaceable;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockBreakHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialTools;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class ExplosiveShovel
extends SimpleSlimefunItem<BlockBreakHandler>
implements NotPlaceable,
DamageableItem {
    private boolean damageOnUse;

    public ExplosiveShovel(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, String[] keys, Object[] values) {
        super(category, item, recipeType, recipe, keys, values);
    }

    @Override
    public BlockBreakHandler getItemHandler() {
        return new BlockBreakHandler(){

            @Override
            public boolean isPrivate() {
                return false;
            }

            @Override
            public boolean onBlockBreak(BlockBreakEvent e, ItemStack item, int fortune, List<ItemStack> drops) {
                if (ExplosiveShovel.this.isItem(item)) {
                    if (Slimefun.hasUnlocked(e.getPlayer(), ExplosiveShovel.this, true)) {
                        e.getBlock().getWorld().createExplosion(e.getBlock().getLocation(), 0.0f);
                        e.getBlock().getWorld().playSound(e.getBlock().getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 0.3f, 1.0f);
                        for (int x = -1; x <= 1; ++x) {
                            for (int y = -1; y <= 1; ++y) {
                                for (int z = -1; z <= 1; ++z) {
                                    if (x == 0 && y == 0 && z == 0) continue;
                                    Block b = e.getBlock().getRelative(x, y, z);
                                    if (!MaterialTools.getBreakableByShovel().contains(b.getType()) || !SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b.getLocation(), ProtectableAction.BREAK_BLOCK)) continue;
                                    SlimefunPlugin.getProtectionManager().logAction((OfflinePlayer)e.getPlayer(), b, ProtectableAction.BREAK_BLOCK);
                                    b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
                                    for (ItemStack drop : b.getDrops(ExplosiveShovel.this.getItem())) {
                                        if (drop == null) continue;
                                        b.getWorld().dropItemNaturally(b.getLocation(), drop);
                                    }
                                    b.setType(Material.AIR);
                                    ExplosiveShovel.this.damageItem(e.getPlayer(), item);
                                }
                            }
                        }
                    }
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public void postRegister() {
        this.damageOnUse = (Boolean)Slimefun.getItemValue(this.getID(), "damage-on-use");
    }

    @Override
    public boolean isDamageable() {
        return this.damageOnUse;
    }
}

