/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects;

import io.github.thebusybiscuit.slimefun4.api.events.ResearchUnlockEvent;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.utils.FireworkUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Research
implements Keyed {
    private static final int[] RESEARCH_PROGRESS = new int[]{23, 44, 57, 92};
    private final NamespacedKey key;
    private final int id;
    private String name;
    private boolean enabled = true;
    private int cost;
    private final List<SlimefunItem> items = new LinkedList<SlimefunItem>();

    public Research(NamespacedKey key, int id, String name, int defaultCost) {
        this.key = key;
        this.id = id;
        this.name = name;
        this.cost = defaultCost;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public boolean isEnabled() {
        return SlimefunPlugin.getRegistry().isResearchingEnabled() && this.enabled;
    }

    public int getID() {
        return this.id;
    }

    public String getName(Player p) {
        String localized = SlimefunPlugin.getLocal().getResearchName(p, this.key);
        return localized != null ? localized : this.name;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public void addItems(SlimefunItem ... items) {
        for (SlimefunItem item : items) {
            if (item == null) continue;
            item.bindToResearch(this);
        }
    }

    public List<SlimefunItem> getAffectedItems() {
        return this.items;
    }

    public boolean canUnlock(Player p) {
        if (!this.isEnabled()) {
            return true;
        }
        boolean creativeResearch = p.getGameMode() == GameMode.CREATIVE && SlimefunPlugin.getRegistry().isFreeCreativeResearchingEnabled();
        return creativeResearch || p.getLevel() >= this.cost;
    }

    public void unlock(Player p, boolean instant) {
        if (!instant) {
            Slimefun.runSync(() -> {
                p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.research.progress", true, msg -> msg.replace("%research%", this.getName(p)).replace("%progress%", "0%"));
            }, 10L);
        }
        PlayerProfile.get((OfflinePlayer)p, profile -> {
            if (!profile.hasUnlocked(this)) {
                Runnable runnable = () -> {
                    profile.setResearched(this, true);
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.unlocked", true, msg -> msg.replace("%research%", this.getName(p)));
                    if (SlimefunPlugin.getRegistry().isResearchFireworkEnabled() && SlimefunGuideSettings.hasFireworksEnabled(p)) {
                        FireworkUtils.launchRandom((Entity)p, 1);
                    }
                };
                Slimefun.runSync(() -> {
                    ResearchUnlockEvent event = new ResearchUnlockEvent(p, this);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        if (instant) {
                            runnable.run();
                        } else if (SlimefunPlugin.getRegistry().getCurrentlyResearchingPlayers().add(p.getUniqueId())) {
                            SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.research.start", true, msg -> msg.replace("%research%", this.getName(p)));
                            this.playResearchAnimation(p);
                            Slimefun.runSync(() -> {
                                runnable.run();
                                SlimefunPlugin.getRegistry().getCurrentlyResearchingPlayers().remove(p.getUniqueId());
                            }, (long)(RESEARCH_PROGRESS.length + 1) * 20L);
                        }
                    }
                });
            }
        });
    }

    private void playResearchAnimation(Player p) {
        for (int i = 1; i < RESEARCH_PROGRESS.length + 1; ++i) {
            int j = i;
            Slimefun.runSync(() -> {
                p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.research.progress", true, msg -> msg.replace("%research%", this.getName(p)).replace("%progress%", RESEARCH_PROGRESS[j - 1] + "%"));
            }, (long)i * 20L);
        }
    }

    public void register() {
        SlimefunPlugin.getResearchCfg().setDefaultValue("enable-researching", true);
        String path = this.key.getNamespace() + '.' + this.key.getKey();
        this.migrate(this.id, path);
        if (SlimefunPlugin.getResearchCfg().contains(path + ".enabled") && !SlimefunPlugin.getResearchCfg().getBoolean(path + ".enabled")) {
            Iterator<SlimefunItem> iterator = this.items.iterator();
            while (iterator.hasNext()) {
                SlimefunItem item = iterator.next();
                if (item != null) {
                    item.bindToResearch(null);
                }
                iterator.remove();
            }
            return;
        }
        SlimefunPlugin.getResearchCfg().setDefaultValue(path + ".cost", this.getCost());
        SlimefunPlugin.getResearchCfg().setDefaultValue(path + ".enabled", true);
        this.cost = SlimefunPlugin.getResearchCfg().getInt(path + ".cost");
        this.enabled = SlimefunPlugin.getResearchCfg().getBoolean(path + ".enabled");
        SlimefunPlugin.getRegistry().getResearches().add(this);
        SlimefunPlugin.getRegistry().getResearchIds().add(this);
    }

    private void migrate(int id, String path) {
        if (SlimefunPlugin.getResearchCfg().contains(id + ".enabled")) {
            SlimefunPlugin.getResearchCfg().setValue(path + ".enabled", SlimefunPlugin.getResearchCfg().getBoolean(id + ".enabled"));
        }
        if (SlimefunPlugin.getResearchCfg().contains(id + ".cost")) {
            SlimefunPlugin.getResearchCfg().setValue(path + ".cost", SlimefunPlugin.getResearchCfg().getInt(id + ".cost"));
        }
        SlimefunPlugin.getResearchCfg().setValue(String.valueOf(id), null);
    }

    public static Research getByID(int id) {
        for (Research research : SlimefunPlugin.getRegistry().getResearches()) {
            if (research.getID() != id) continue;
            return research;
        }
        return null;
    }

    public String toString() {
        return "Research {" + this.id + ',' + this.name + "}";
    }
}

