/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import java.util.Optional;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class BlockDataService {
    private final NamespacedKey namespacedKey;

    public BlockDataService(Plugin plugin, String key) {
        this.namespacedKey = new NamespacedKey(plugin, key);
    }

    public void setBlockData(Block b, String value) {
        BlockState state = b.getState();
        if (state instanceof TileState) {
            PersistentDataAPI.setString((PersistentDataHolder)((TileState)state), this.namespacedKey, value);
            state.update();
        }
    }

    public Optional<String> getBlockData(Block b) {
        BlockState state = b.getState();
        if (state instanceof TileState) {
            return PersistentDataAPI.getOptionalString((PersistentDataHolder)((TileState)state), this.namespacedKey);
        }
        return Optional.empty();
    }

    public boolean isTileEntity(Material type) {
        switch (type) {
            case PLAYER_HEAD: 
            case PLAYER_WALL_HEAD: 
            case CHEST: 
            case DISPENSER: 
            case DROPPER: 
            case FURNACE: 
            case BLAST_FURNACE: 
            case HOPPER: 
            case LECTERN: 
            case JUKEBOX: 
            case ENDER_CHEST: 
            case ENCHANTING_TABLE: 
            case DAYLIGHT_DETECTOR: 
            case SMOKER: 
            case SPAWNER: 
            case BEACON: {
                return true;
            }
        }
        return false;
    }
}

