/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks.armor;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets.SolarHelmet;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.armor.AbstractArmorTask;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SolarHelmetTask
extends AbstractArmorTask {
    @Override
    @ParametersAreNonnullByDefault
    protected void onPlayerTick(Player p, PlayerProfile profile) {
        if (this.hasSunlight(p)) {
            this.checkForSolarHelmet(p);
        }
    }

    private void checkForSolarHelmet(@Nonnull Player p) {
        ItemStack helmet = p.getInventory().getHelmet();
        SlimefunItem item = SlimefunItem.getByItem(helmet);
        if (item instanceof SolarHelmet) {
            SolarHelmet solarHelmet = (SolarHelmet)item;
            if (item.canUse(p, true)) {
                solarHelmet.rechargeItems(p);
            }
        }
    }

    private boolean hasSunlight(@Nonnull Player p) {
        World world = p.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return false;
        }
        return (world.getTime() < 12300L || world.getTime() > 23850L) && p.getEyeLocation().getBlock().getLightFromSky() == 15;
    }
}

