/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters.AbstractRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.features.blockstatesnapshot.BlockStateSnapshotResult;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedParticle;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public abstract class AbstractAutoCrafter
extends SlimefunItem
implements EnergyNetComponent {
    private int energyConsumed = -1;
    private int energyCapacity = -1;
    protected final NamespacedKey recipeStorageKey;
    protected final NamespacedKey recipeEnabledKey;
    protected final int[] background = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 15, 16, 17, 18, 19, 23, 25, 26, 27, 28, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};

    @ParametersAreNonnullByDefault
    protected AbstractAutoCrafter(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.recipeStorageKey = new NamespacedKey((Plugin)Slimefun.instance(), "recipe_key");
        this.recipeEnabledKey = new NamespacedKey((Plugin)Slimefun.instance(), "recipe_enabled");
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem item, Config data) {
                AbstractAutoCrafter.this.tick(b, data);
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        });
    }

    @ParametersAreNonnullByDefault
    public void onRightClick(Block b, Player p) {
        Validate.notNull(b, "The Block must not be null!");
        Validate.notNull(p, "The Player cannot be null!");
        if (!this.isValidInventory(b.getRelative(BlockFace.DOWN))) {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.missing-chest");
        } else if (Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b, Interaction.INTERACT_BLOCK)) {
            if (p.isSneaking()) {
                this.updateRecipe(b, p);
            } else {
                AbstractRecipe recipe = this.getSelectedRecipe(b);
                if (recipe == null) {
                    Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.select-a-recipe");
                } else {
                    this.showRecipe(p, b, recipe);
                }
            }
        } else {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "inventory.no-access");
        }
    }

    protected void tick(@Nonnull Block b, @Nonnull Config data) {
        InventoryHolder inventoryHolder;
        Inventory inv;
        BlockState state;
        AbstractRecipe recipe = this.getSelectedRecipe(b);
        if (recipe == null || !recipe.isEnabled() || this.getCharge(b.getLocation(), data) < this.getEnergyConsumption()) {
            return;
        }
        Block targetBlock = b.getRelative(BlockFace.DOWN);
        if (this.isValidInventory(targetBlock) && (state = PaperLib.getBlockState(targetBlock, false).getState()) instanceof InventoryHolder && this.craft(inv = (inventoryHolder = (InventoryHolder)state).getInventory(), recipe)) {
            Location loc = b.getLocation().add(0.5, 0.8, 0.5);
            b.getWorld().spawnParticle(VersionedParticle.HAPPY_VILLAGER, loc, 6);
            this.removeCharge(b.getLocation(), this.getEnergyConsumption());
        }
    }

    protected boolean isValidInventory(@Nonnull Block block) {
        Material type = block.getType();
        return SlimefunTag.AUTO_CRAFTER_SUPPORTED_STORAGE_BLOCKS.isTagged(type);
    }

    @Nullable
    public abstract AbstractRecipe getSelectedRecipe(@Nonnull Block var1);

    protected abstract void updateRecipe(@Nonnull Block var1, @Nonnull Player var2);

    protected void setSelectedRecipe(@Nonnull Block b, @Nullable AbstractRecipe recipe) {
        Validate.notNull(b, "The Block cannot be null!");
        BlockStateSnapshotResult result = PaperLib.getBlockState(b, false);
        BlockState state = result.getState();
        if (state instanceof Skull) {
            Skull skull = (Skull)state;
            if (recipe == null) {
                PersistentDataAPI.remove((PersistentDataHolder)skull, this.recipeStorageKey);
                PersistentDataAPI.remove((PersistentDataHolder)skull, this.recipeEnabledKey);
            } else {
                PersistentDataAPI.setString((PersistentDataHolder)skull, this.recipeStorageKey, recipe.toString());
            }
            if (result.isSnapshot()) {
                state.update(true, false);
            }
        }
    }

    @ParametersAreNonnullByDefault
    protected void showRecipe(Player p, Block b, AbstractRecipe recipe) {
        Validate.notNull(p, "The Player should not be null");
        Validate.notNull(b, "The Block should not be null");
        Validate.notNull(recipe, "The Recipe should not be null");
        ChestMenu menu = new ChestMenu(this.getItemName());
        menu.setPlayerInventoryClickable(false);
        menu.setEmptySlotsClickable(false);
        ChestMenuUtils.drawBackground(menu, this.background);
        ChestMenuUtils.drawBackground(menu, 45, 46, 47, 48, 50, 51, 52, 53);
        if (recipe.isEnabled()) {
            menu.addItem(49, CustomItemStack.create(Material.BARRIER, Slimefun.getLocalization().getMessages(p, "messages.auto-crafting.tooltips.enabled")));
            menu.addMenuClickHandler(49, (pl, item, slot, action) -> {
                if (action.isRightClicked()) {
                    this.deleteRecipe(pl, b);
                } else {
                    this.setRecipeEnabled(pl, b, false);
                }
                return false;
            });
        } else {
            menu.addItem(49, CustomItemStack.create(HeadTexture.EXCLAMATION_MARK.getAsItemStack(), Slimefun.getLocalization().getMessages(p, "messages.auto-crafting.tooltips.disabled")));
            menu.addMenuClickHandler(49, (pl, item, slot, action) -> {
                if (action.isRightClicked()) {
                    this.deleteRecipe(pl, b);
                } else {
                    this.setRecipeEnabled(pl, b, true);
                }
                return false;
            });
        }
        AsyncRecipeChoiceTask task = new AsyncRecipeChoiceTask();
        recipe.show(menu, task);
        menu.open(p);
        SoundEffect.AUTO_CRAFTER_GUI_CLICK_SOUND.playFor(p);
        if (!task.isEmpty()) {
            task.start(menu.toInventory());
        }
    }

    @ParametersAreNonnullByDefault
    private void setRecipeEnabled(Player p, Block b, boolean enabled) {
        p.closeInventory();
        SoundEffect.AUTO_CRAFTER_GUI_CLICK_SOUND.playFor(p);
        BlockState state = PaperLib.getBlockState(b, false).getState();
        if (state instanceof Skull) {
            Skull skull = (Skull)state;
            if (enabled) {
                PersistentDataAPI.remove((PersistentDataHolder)skull, this.recipeEnabledKey);
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.re-enabled");
            } else {
                PersistentDataAPI.setByte((PersistentDataHolder)skull, this.recipeEnabledKey, (byte)1);
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.temporarily-disabled");
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void deleteRecipe(Player p, Block b) {
        this.setSelectedRecipe(b, null);
        p.closeInventory();
        SoundEffect.AUTO_CRAFTER_GUI_CLICK_SOUND.playFor(p);
        Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.recipe-removed");
    }

    @ParametersAreNonnullByDefault
    protected boolean matches(ItemStack item, Predicate<ItemStack> predicate) {
        return predicate.test(item);
    }

    @ParametersAreNonnullByDefault
    protected boolean matchesAny(Inventory inv, Map<Integer, Integer> itemQuantities, Predicate<ItemStack> predicate) {
        ItemStack[] contents = inv.getContents();
        for (int slot = 0; slot < contents.length; ++slot) {
            int amount;
            ItemStack item = contents[slot];
            if (item == null || (amount = itemQuantities.getOrDefault(slot, item.getAmount()).intValue()) <= 0 || !this.matches(item, predicate)) continue;
            itemQuantities.put(slot, amount - 1);
            return true;
        }
        return false;
    }

    public boolean craft(@Nonnull Inventory inv, @Nonnull AbstractRecipe recipe) {
        Validate.notNull(inv, "The Inventory must not be null");
        Validate.notNull(recipe, "The Recipe shall not be null");
        if (!recipe.isEnabled()) {
            return false;
        }
        if (inv.firstEmpty() != -1) {
            HashMap<Integer, Integer> itemQuantities = new HashMap<Integer, Integer>();
            for (Predicate<ItemStack> predicate : recipe.getIngredients()) {
                if (this.matchesAny(inv, itemQuantities, predicate)) continue;
                return false;
            }
            ArrayList<ItemStack> leftoverItems = new ArrayList<ItemStack>();
            for (Map.Entry entry : itemQuantities.entrySet()) {
                ItemStack item = inv.getItem(((Integer)entry.getKey()).intValue());
                if (item == null) continue;
                ItemStack leftover = this.getLeftoverItem(item);
                if (leftover != null) {
                    leftover.setAmount(item.getAmount() - (Integer)entry.getValue());
                    leftoverItems.add(leftover);
                }
                item.setAmount(((Integer)entry.getValue()).intValue());
            }
            boolean success = inv.addItem(new ItemStack[]{recipe.getResult().clone()}).isEmpty();
            if (success) {
                for (ItemStack leftoverItem : leftoverItems) {
                    inv.addItem(new ItemStack[]{leftoverItem});
                }
            }
            return success;
        }
        return false;
    }

    @Nullable
    private ItemStack getLeftoverItem(@Nonnull ItemStack item) {
        Material type = item.getType();
        return switch (type) {
            case Material.WATER_BUCKET, Material.LAVA_BUCKET, Material.MILK_BUCKET -> new ItemStack(Material.BUCKET);
            case Material.DRAGON_BREATH, Material.POTION, Material.HONEY_BOTTLE -> new ItemStack(Material.GLASS_BOTTLE);
            default -> null;
        };
    }

    @Override
    public int getCapacity() {
        return this.energyCapacity;
    }

    public int getEnergyConsumption() {
        return this.energyConsumed;
    }

    @Nonnull
    public final AbstractAutoCrafter setCapacity(int capacity) {
        Validate.isTrue(capacity > 0, "The capacity must be greater than zero!");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    @Nonnull
    public final AbstractAutoCrafter setEnergyConsumption(int energyConsumption) {
        Validate.isTrue(energyConsumption > 0, "The energy consumption must be greater than zero!");
        Validate.isTrue(this.energyCapacity > 0, "You must specify the capacity before you can set the consumption amount.");
        Validate.isTrue(energyConsumption <= this.energyCapacity, "The energy consumption cannot be higher than the capacity (" + this.energyCapacity + ")");
        this.energyConsumed = energyConsumption;
        return this;
    }

    @Override
    public void register(@Nonnull SlimefunAddon addon) {
        Validate.notNull(addon, "A SlimefunAddon cannot be null!");
        this.addon = addon;
        if (this.getCapacity() <= 0) {
            this.warn("The capacity has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + this.getClass().getSimpleName() + "#setEnergyCapacity(...)' before registering!");
        }
        if (this.getEnergyConsumption() <= 0) {
            this.warn("The energy consumption has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + this.getClass().getSimpleName() + "#setEnergyConsumption(...)' before registering!");
        }
        if (this.getCapacity() > 0 && this.getEnergyConsumption() > 0) {
            super.register(addon);
        }
    }

    @Override
    public final EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }
}

