/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ProgrammableAndroid;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class Script {
    private final Config config;
    private final String name;
    private final String author;
    private final String code;

    private Script(@Nonnull Config config) {
        Validate.notNull(config);
        this.config = config;
        this.name = config.getString("name");
        this.code = config.getString("code");
        String uuid = config.getString("author");
        Validate.notNull(this.name);
        Validate.notNull(this.code);
        Validate.notNull(uuid);
        Validate.notNull(config.getStringList("rating.positive"));
        Validate.notNull(config.getStringList("rating.negative"));
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid));
        this.author = player.getName() != null ? player.getName() : config.getString("author_name");
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getAuthor() {
        return this.author;
    }

    @Nonnull
    public String getSourceCode() {
        return this.code;
    }

    public boolean isAuthor(@Nonnull OfflinePlayer p) {
        return p.getUniqueId().equals(this.config.getUUID("author"));
    }

    public boolean canRate(@Nonnull Player p) {
        if (this.isAuthor((OfflinePlayer)p)) {
            return false;
        }
        List<String> upvoters = this.config.getStringList("rating.positive");
        List<String> downvoters = this.config.getStringList("rating.negative");
        return !upvoters.contains(p.getUniqueId().toString()) && !downvoters.contains(p.getUniqueId().toString());
    }

    @Nonnull
    ItemStack getAsItemStack(@Nonnull ProgrammableAndroid android, @Nonnull Player p) {
        LinkedList<Object> lore = new LinkedList<Object>();
        lore.add("&7by &f" + this.getAuthor());
        lore.add("");
        lore.add("&7Downloads: &f" + this.getDownloads());
        lore.add("&7Rating: " + this.getScriptRatingPercentage());
        lore.add("&a" + this.getUpvotes() + " \u263a &7| &4\u2639 " + this.getDownvotes());
        lore.add("");
        lore.add("&eLeft Click &fto download this Script");
        lore.add("&4(This will override your current Script)");
        if (this.canRate(p)) {
            lore.add("");
            lore.add("&eShift + Left Click &fto leave a positive Rating");
            lore.add("&eShift + Right Click &fto leave a negative Rating");
        }
        return CustomItemStack.create(android.getItem(), "&b" + this.getName(), lore.toArray(new String[0]));
    }

    @Nonnull
    private String getScriptRatingPercentage() {
        float percentage = this.getRating();
        return String.valueOf(NumberUtils.getColorFromPercentage(percentage)) + String.valueOf(percentage) + String.valueOf(ChatColor.WHITE) + "% ";
    }

    public int getUpvotes() {
        return this.config.getStringList("rating.positive").size();
    }

    public int getDownvotes() {
        return this.config.getStringList("rating.negative").size();
    }

    public int getDownloads() {
        return this.config.getInt("downloads");
    }

    public float getRating() {
        int positive = this.getUpvotes() + 1;
        int negative = this.getDownvotes();
        return (float)Math.round((float)positive / (float)(positive + negative) * 100.0f) / 100.0f;
    }

    public void download() {
        this.config.reload();
        this.config.setValue("downloads", this.getDownloads() + 1);
        this.config.save();
    }

    public void rate(@Nonnull Player p, boolean positive) {
        this.config.reload();
        String path = "rating." + (positive ? "positive" : "negative");
        List<String> list = this.config.getStringList(path);
        list.add(p.getUniqueId().toString());
        this.config.setValue(path, list);
        this.config.save();
    }

    @Nonnull
    public static List<Script> getUploadedScripts(@Nonnull AndroidType androidType) {
        LinkedList<Script> scripts = new LinkedList<Script>();
        Script.loadScripts(scripts, androidType);
        if (androidType != AndroidType.NONE) {
            Script.loadScripts(scripts, AndroidType.NONE);
        }
        Collections.sort(scripts, Comparator.comparingInt(script -> -script.getUpvotes() + 1 - script.getDownvotes()));
        return scripts;
    }

    private static void loadScripts(@Nonnull List<Script> scripts, @Nonnull AndroidType type) {
        File directory = new File("plugins/Slimefun/scripts/" + type.name());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        for (File file : directory.listFiles()) {
            if (!file.getName().endsWith(".sfs")) continue;
            try {
                Config config = new Config(file);
                if (!config.contains("code") || !config.contains("author")) continue;
                scripts.add(new Script(config));
            }
            catch (Exception x) {
                Slimefun.logger().log(Level.SEVERE, x, () -> "An Exception occurred while trying to load Android Script '" + file.getName() + "'");
            }
        }
    }

    @ParametersAreNonnullByDefault
    public static void upload(Player p, AndroidType androidType, int id, String name, String code) {
        Config config = new Config("plugins/Slimefun/scripts/" + androidType.name() + "/" + p.getName() + " " + id + ".sfs");
        config.setValue("author", p.getUniqueId().toString());
        config.setValue("author_name", p.getName());
        config.setValue("name", ChatUtils.removeColorCodes(name));
        config.setValue("code", code);
        config.setValue("downloads", 0);
        config.setValue("android", androidType.name());
        config.setValue("rating.positive", new ArrayList());
        config.setValue("rating.negative", new ArrayList());
        config.save();
    }
}

