/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.gps;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class Waypoint {
    private final UUID ownerId;
    private final String id;
    private final String name;
    private final Location location;

    @Deprecated
    @ParametersAreNonnullByDefault
    public Waypoint(PlayerProfile profile, String id, Location loc, String name) {
        this(profile.getUUID(), id, loc, name);
    }

    @ParametersAreNonnullByDefault
    public Waypoint(UUID ownerId, String id, Location loc, String name) {
        Validate.notNull(ownerId, "owner ID must never be null!");
        Validate.notNull(id, "id must never be null!");
        Validate.notNull(loc, "Location must never be null!");
        Validate.notNull(name, "Name must never be null!");
        this.ownerId = ownerId;
        this.id = id;
        this.location = loc;
        this.name = name;
    }

    @Nonnull
    public UUID getOwnerId() {
        return this.ownerId;
    }

    @Nonnull
    @Deprecated
    public PlayerProfile getOwner() {
        return PlayerProfile.find(Bukkit.getOfflinePlayer((UUID)this.ownerId)).orElse(null);
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Location getLocation() {
        return this.location;
    }

    public boolean isDeathpoint() {
        return this.name.startsWith("player:death ");
    }

    @Nonnull
    public ItemStack getIcon() {
        return Slimefun.getGPSNetwork().getIcon(this.name, this.location.getWorld().getEnvironment());
    }

    public int hashCode() {
        return Objects.hash(this.ownerId, this.id, this.name, this.location);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Waypoint)) {
            return false;
        }
        Waypoint waypoint = (Waypoint)obj;
        return this.ownerId.equals(waypoint.getOwnerId()) && this.id.equals(waypoint.getId()) && this.location.equals((Object)waypoint.getLocation()) && this.name.equals(waypoint.getName());
    }
}

