/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.CSCoreLibPlugin.Configuration;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private final File file;
    private FileConfiguration config;

    public Config(File file) {
        this(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
    }

    public Config(File file, FileConfiguration config) {
        this.file = file;
        this.config = config;
    }

    public Config(String path) {
        this.file = new File(path);
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfiguration() {
        return this.config;
    }

    public void setValue(String path, Object value) {
        this.config.set(path, value);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save(File file) {
        try {
            this.config.save(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setDefaultValue(String path, Object value) {
        if (!this.contains(path)) {
            this.setValue(path, value);
        }
    }

    public boolean contains(String path) {
        return this.config.contains(path);
    }

    public Object getValue(String path) {
        return this.config.get(path);
    }

    public String getString(String path) {
        return this.config.getString(path);
    }

    public void createFile() {
        try {
            this.file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Set<String> getKeys() {
        return this.config.getKeys(false);
    }

    public Set<String> getKeys(String path) {
        return this.config.getConfigurationSection(path).getKeys(false);
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }
}

