/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class HeatedPressureChamber
extends AContainer {
    @ParametersAreNonnullByDefault
    public HeatedPressureChamber(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        new BlockMenuPreset(this.getId(), this.getItemName()){

            @Override
            public void init() {
                HeatedPressureChamber.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return HeatedPressureChamber.this.getOutputSlots();
                }
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int slot : HeatedPressureChamber.this.getInputSlots()) {
                    if (!SlimefunUtils.isItemSimilar(menu.getItemInSlot(slot), item, true)) continue;
                    slots.add(slot);
                }
                if (slots.isEmpty()) {
                    return HeatedPressureChamber.this.getInputSlots();
                }
                Collections.sort(slots, HeatedPressureChamber.this.compareSlots(menu));
                int[] array = new int[slots.size()];
                for (int i = 0; i < slots.size(); ++i) {
                    array[i] = (Integer)slots.get(i);
                }
                return array;
            }
        };
    }

    private Comparator<Integer> compareSlots(DirtyChestMenu menu) {
        return Comparator.comparingInt(slot -> menu.getItemInSlot((int)slot).getAmount());
    }

    @Override
    protected void registerDefaultRecipes() {
        this.registerRecipe(45, new ItemStack[]{SlimefunItems.OIL_BUCKET.item()}, new ItemStack[]{CustomItemStack.create(SlimefunItems.PLASTIC_SHEET.item(), 8)});
        this.registerRecipe(30, new SlimefunItemStack[]{SlimefunItems.GOLD_24K, SlimefunItems.URANIUM}, new SlimefunItemStack[]{SlimefunItems.BLISTERING_INGOT});
        this.registerRecipe(30, new SlimefunItemStack[]{SlimefunItems.BLISTERING_INGOT, SlimefunItems.CARBONADO}, new SlimefunItemStack[]{SlimefunItems.BLISTERING_INGOT_2});
        this.registerRecipe(60, new ItemStack[]{SlimefunItems.BLISTERING_INGOT_2.item(), new ItemStack(Material.NETHER_STAR)}, new ItemStack[]{SlimefunItems.BLISTERING_INGOT_3.item()});
        this.registerRecipe(90, new SlimefunItemStack[]{SlimefunItems.PLUTONIUM, SlimefunItems.URANIUM}, new SlimefunItemStack[]{SlimefunItems.BOOSTED_URANIUM});
        this.registerRecipe(60, new ItemStack[]{SlimefunItems.NETHER_ICE.item(), SlimefunItems.PLUTONIUM.item()}, new ItemStack[]{CustomItemStack.create(SlimefunItems.ENRICHED_NETHER_ICE.item(), 4)});
        this.registerRecipe(45, new ItemStack[]{SlimefunItems.ENRICHED_NETHER_ICE.item()}, new ItemStack[]{CustomItemStack.create(SlimefunItems.NETHER_ICE_COOLANT_CELL.item(), 8)});
        this.registerRecipe(8, new SlimefunItemStack[]{SlimefunItems.MAGNESIUM_DUST, SlimefunItems.SALT}, new SlimefunItemStack[]{SlimefunItems.MAGNESIUM_SALT});
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.FLINT_AND_STEEL);
    }

    @Override
    public String getMachineIdentifier() {
        return "HEATED_PRESSURE_CHAMBER";
    }
}

