/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.entities;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class ExpCollector
extends SlimefunItem
implements InventoryBlock,
EnergyNetComponent {
    private final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private static final String DATA_KEY = "stored-exp";
    private final double range;
    private int energyConsumedPerTick = -1;
    private int energyCapacity = -1;

    @Deprecated(since="RC-38", forRemoval=true)
    @ParametersAreNonnullByDefault
    public ExpCollector(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        this(itemGroup, item, recipeType, recipe, 4.0);
    }

    @ParametersAreNonnullByDefault
    public ExpCollector(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, double range) {
        super(itemGroup, item, recipeType, recipe);
        this.range = range;
        this.createPreset(this, this::constructMenu);
        this.addItemHandler(this.onPlace(), this.onBreak());
    }

    @Nonnull
    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            @Override
            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                BlockStorage.addBlockInfo(e.getBlock(), "owner", e.getPlayer().getUniqueId().toString());
            }
        };
    }

    @Nonnull
    private ItemHandler onBreak() {
        return new SimpleBlockBreakHandler(){

            @Override
            public void onBlockBreak(@Nonnull Block b) {
                BlockMenu inv = BlockStorage.getInventory(b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), ExpCollector.this.getOutputSlots());
                }
            }
        };
    }

    @Override
    public int[] getInputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{12, 13, 14};
    }

    @Override
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int slot : this.border) {
            preset.addItem(slot, CustomItemStack.create(Material.PURPLE_STAINED_GLASS_PANE, " ", new String[0]), (p, s, item, action) -> false);
        }
    }

    @Override
    public void preRegister() {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                ExpCollector.this.tick(b);
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        });
    }

    protected void tick(Block block) {
        Location location = block.getLocation();
        Iterator iterator = block.getWorld().getNearbyEntities(location, this.range, this.range, this.range, n -> n instanceof ExperienceOrb && n.isValid()).iterator();
        int experiencePoints = 0;
        while (iterator.hasNext() && experiencePoints == 0) {
            ExperienceOrb orb = (ExperienceOrb)iterator.next();
            if (this.getCharge(location) < this.getEnergyConsumption()) {
                return;
            }
            experiencePoints = this.getStoredExperience(location) + orb.getExperience();
            this.removeCharge(location, this.getEnergyConsumption());
            orb.remove();
            this.produceFlasks(location, experiencePoints);
        }
    }

    private void produceFlasks(@Nonnull Location location, int experiencePoints) {
        int withdrawn = 0;
        BlockMenu menu = BlockStorage.getInventory(location);
        for (int level = 0; level < this.getStoredExperience(location) && menu.fits(SlimefunItems.FILLED_FLASK_OF_KNOWLEDGE, this.getOutputSlots()); level += 10) {
            withdrawn += 10;
            menu.pushItem(SlimefunItems.FILLED_FLASK_OF_KNOWLEDGE.clone(), this.getOutputSlots());
        }
        BlockStorage.addBlockInfo(location, DATA_KEY, String.valueOf(experiencePoints - withdrawn));
    }

    private int getStoredExperience(Location location) {
        Config cfg = BlockStorage.getLocationInfo(location);
        String value = cfg.getString(DATA_KEY);
        if (value != null) {
            return Integer.parseInt(value);
        }
        BlockStorage.addBlockInfo(location, DATA_KEY, "0");
        return 0;
    }

    public int getEnergyConsumption() {
        return this.energyConsumedPerTick;
    }

    public ExpCollector setEnergyConsumption(int energyConsumedPerTick) {
        this.energyConsumedPerTick = energyConsumedPerTick;
        return this;
    }

    @Override
    public int getCapacity() {
        return this.energyCapacity;
    }

    public ExpCollector setCapacity(int energyCapacity) {
        this.energyCapacity = energyCapacity;
        return this;
    }
}

