/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class GitHubConnector {
    private static final String API_URL = "https://api.github.com/";
    private static final String USER_AGENT = "Slimefun4 (https://github.com/Slimefun)";
    private static final HttpClient client = HttpClient.newHttpClient();
    protected final GitHubService github;
    private final String url;
    private File file;

    GitHubConnector(@Nonnull GitHubService github, @Nonnull String repository) {
        this.github = github;
        this.url = "https://api.github.com/repos/" + repository + this.getEndpoint();
    }

    @Nonnull
    public abstract String getFileName();

    @Nonnull
    public abstract String getEndpoint();

    @Nonnull
    public abstract Map<String, Object> getParameters();

    public abstract void onSuccess(@Nonnull JsonElement var1);

    public void onFailure() {
    }

    void download() {
        this.file = new File("plugins/Slimefun/cache/github/" + this.getFileName() + ".json");
        if (this.github.isLoggingEnabled()) {
            Slimefun.logger().log(Level.INFO, "Retrieving {0}.json from GitHub...", this.getFileName());
        }
        try {
            String params = this.getParameters().entrySet().stream().map(p -> (String)p.getKey() + "=" + String.valueOf(p.getValue())).reduce((p1, p2) -> p1 + "&" + p2).map(s -> "?" + s).orElse("");
            URI uri = new URI(this.url + params);
            HttpResponse<String> response = client.send(HttpRequest.newBuilder(uri).header("User-Agent", USER_AGENT).build(), HttpResponse.BodyHandlers.ofString());
            JsonElement element = JsonUtils.parseString(response.body());
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                this.onSuccess(element);
                this.writeCacheFile(element);
            } else {
                JsonElement cache;
                if (this.github.isLoggingEnabled()) {
                    Slimefun.logger().log(Level.WARNING, "Failed to fetch {0}: {1} - {2}", new Object[]{this.url, response.statusCode(), element});
                }
                if (this.file.exists() && (cache = this.readCacheFile()) != null) {
                    this.onSuccess(cache);
                }
            }
        }
        catch (JsonParseException | IOException | InterruptedException | URISyntaxException e) {
            JsonElement cache;
            if (this.github.isLoggingEnabled()) {
                Slimefun.logger().log(Level.WARNING, "Could not connect to GitHub in time.", e);
            }
            if (this.file.exists() && (cache = this.readCacheFile()) != null) {
                this.onSuccess(cache);
                return;
            }
            this.onFailure();
        }
    }

    @Nullable
    private JsonElement readCacheFile() {
        JsonElement jsonElement;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));
        try {
            jsonElement = JsonUtils.parseString(reader.readLine());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException | IOException e) {
                Slimefun.logger().log(Level.WARNING, "Failed to read Github cache file: {0} - {1}: {2}", new Object[]{this.file.getName(), e.getClass().getSimpleName(), e.getMessage()});
                return null;
            }
        }
        reader.close();
        return jsonElement;
    }

    private void writeCacheFile(@Nonnull JsonElement node) {
        try (FileOutputStream output = new FileOutputStream(this.file);){
            output.write(node.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            Slimefun.logger().log(Level.WARNING, "Failed to populate GitHub cache: {0} - {1}", new Object[]{e.getClass().getSimpleName(), e.getMessage()});
        }
    }
}

