/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.guide;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public interface SlimefunGuideImplementation {
    @Nonnull
    public SlimefunGuideMode getMode();

    @Nonnull
    public ItemStack getItem();

    @ParametersAreNonnullByDefault
    public void openMainMenu(PlayerProfile var1, int var2);

    @ParametersAreNonnullByDefault
    public void openItemGroup(PlayerProfile var1, ItemGroup var2, int var3);

    @ParametersAreNonnullByDefault
    public void openSearch(PlayerProfile var1, String var2, boolean var3);

    @ParametersAreNonnullByDefault
    public void displayItem(PlayerProfile var1, ItemStack var2, int var3, boolean var4);

    @ParametersAreNonnullByDefault
    public void displayItem(PlayerProfile var1, SlimefunItem var2, boolean var3);

    @ParametersAreNonnullByDefault
    default public void unlockItem(Player p, SlimefunItem sfitem, Consumer<Player> callback) {
        Research research = sfitem.getResearch();
        if (p.getGameMode() == GameMode.CREATIVE && Slimefun.getRegistry().isFreeCreativeResearchingEnabled()) {
            research.unlock(p, true, callback);
        } else {
            p.setLevel(p.getLevel() - research.getCost());
            boolean skipLearningAnimation = Slimefun.getRegistry().isLearningAnimationDisabled() || !SlimefunGuideSettings.hasLearningAnimationEnabled(p);
            research.unlock(p, skipLearningAnimation, callback);
        }
    }
}

