/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.commands;

import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunCommand;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class SubCommand {
    protected final Slimefun plugin;
    protected final SlimefunCommand cmd;
    private final String name;
    private final boolean hidden;

    @ParametersAreNonnullByDefault
    protected SubCommand(Slimefun plugin, SlimefunCommand cmd, String name, boolean hidden) {
        this.plugin = plugin;
        this.cmd = cmd;
        this.name = name;
        this.hidden = hidden;
    }

    @Nonnull
    public final String getName() {
        return this.name;
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    protected void recordUsage(@Nonnull Map<SubCommand, Integer> commandUsage) {
        commandUsage.merge(this, 1, Integer::sum);
    }

    public abstract void onExecute(@Nonnull CommandSender var1, @Nonnull String[] var2);

    @Nonnull
    protected String getDescription() {
        return "commands." + this.getName();
    }

    @Nonnull
    public String getDescription(@Nonnull CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return Slimefun.getLocalization().getMessage(player, this.getDescription());
        }
        return Slimefun.getLocalization().getMessage(this.getDescription());
    }
}

