/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.attributes;

import io.github.thebusybiscuit.slimefun4.core.attributes.ItemAttribute;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;

public interface EnergyNetComponent
extends ItemAttribute {
    @Nonnull
    public EnergyNetComponentType getEnergyComponentType();

    public int getCapacity();

    default public boolean isChargeable() {
        return this.getCapacity() > 0;
    }

    default public int getCharge(@Nonnull Location l) {
        if (!this.isChargeable()) {
            return 0;
        }
        return this.getCharge(l, BlockStorage.getLocationInfo(l));
    }

    default public int getCharge(@Nonnull Location l, @Nonnull Config data) {
        Validate.notNull(l, "Location was null!");
        Validate.notNull(data, "data was null!");
        if (!this.isChargeable()) {
            return 0;
        }
        String charge = data.getString("energy-charge");
        if (charge != null) {
            return Integer.parseInt(charge);
        }
        return 0;
    }

    default public void setCharge(@Nonnull Location l, int charge) {
        Validate.notNull(l, "Location was null!");
        Validate.isTrue(charge >= 0, "You can only set a charge of zero or more!");
        try {
            int capacity = this.getCapacity();
            if (capacity > 0 && (charge = NumberUtils.clamp(0, charge, capacity)) != this.getCharge(l)) {
                BlockStorage.addBlockInfo(l, "energy-charge", String.valueOf(charge), false);
                if (this.getEnergyComponentType() == EnergyNetComponentType.CAPACITOR) {
                    SlimefunUtils.updateCapacitorTexture(l, charge, capacity);
                }
            }
        }
        catch (Exception | LinkageError x) {
            Slimefun.logger().log(Level.SEVERE, x, () -> "Exception while trying to set the energy-charge for \"" + this.getId() + "\" at " + String.valueOf(new BlockPosition(l)));
        }
    }

    default public void addCharge(@Nonnull Location l, int charge) {
        Validate.notNull(l, "Location was null!");
        Validate.isTrue(charge > 0, "You can only add a positive charge!");
        try {
            int currentCharge;
            int capacity = this.getCapacity();
            if (capacity > 0 && (currentCharge = this.getCharge(l)) < capacity) {
                int newCharge = Math.min(capacity, currentCharge + charge);
                BlockStorage.addBlockInfo(l, "energy-charge", String.valueOf(newCharge), false);
                if (this.getEnergyComponentType() == EnergyNetComponentType.CAPACITOR) {
                    SlimefunUtils.updateCapacitorTexture(l, charge, capacity);
                }
            }
        }
        catch (Exception | LinkageError x) {
            Slimefun.logger().log(Level.SEVERE, x, () -> "Exception while trying to add an energy-charge for \"" + this.getId() + "\" at " + String.valueOf(new BlockPosition(l)));
        }
    }

    default public void removeCharge(@Nonnull Location l, int charge) {
        Validate.notNull(l, "Location was null!");
        Validate.isTrue(charge > 0, "The charge to remove must be greater than zero!");
        try {
            int currentCharge;
            int capacity = this.getCapacity();
            if (capacity > 0 && (currentCharge = this.getCharge(l)) > 0) {
                int newCharge = Math.max(0, currentCharge - charge);
                BlockStorage.addBlockInfo(l, "energy-charge", String.valueOf(newCharge), false);
                if (this.getEnergyComponentType() == EnergyNetComponentType.CAPACITOR) {
                    SlimefunUtils.updateCapacitorTexture(l, charge, capacity);
                }
            }
        }
        catch (Exception | LinkageError x) {
            Slimefun.logger().log(Level.SEVERE, x, () -> "Exception while trying to remove an energy-charge for \"" + this.getId() + "\" at " + String.valueOf(new BlockPosition(l)));
        }
    }
}

