/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters.AbstractAutoCrafter;
import io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters.AbstractRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class SlimefunAutoCrafter
extends AbstractAutoCrafter {
    private final RecipeType targetRecipeType;

    @ParametersAreNonnullByDefault
    protected SlimefunAutoCrafter(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, RecipeType targetRecipeType) {
        super(itemGroup, item, recipeType, recipe);
        this.targetRecipeType = targetRecipeType;
    }

    @Override
    @Nullable
    public AbstractRecipe getSelectedRecipe(@Nonnull Block b) {
        Skull skull;
        PersistentDataContainer container;
        String value;
        SlimefunItem item;
        Validate.notNull(b, "The Block cannot be null!");
        BlockState state = PaperLib.getBlockState(b, false).getState();
        if (state instanceof Skull && (item = SlimefunItem.getById(value = (String)(container = (skull = (Skull)state).getPersistentDataContainer()).get(this.recipeStorageKey, PersistentDataType.STRING))) != null) {
            boolean enabled = !container.has(this.recipeEnabledKey, PersistentDataType.BYTE);
            AbstractRecipe recipe = AbstractRecipe.of(item, this.targetRecipeType);
            recipe.setEnabled(enabled);
            return recipe;
        }
        return null;
    }

    @Override
    protected void updateRecipe(@Nonnull Block b, @Nonnull Player p) {
        ItemStack itemInHand = p.getInventory().getItemInMainHand();
        SlimefunItem item = SlimefunItem.getByItem(itemInHand);
        if (item != null && item.getRecipeType().equals(this.targetRecipeType)) {
            if (item.canUse(p, true)) {
                AbstractRecipe recipe = AbstractRecipe.of(item, this.targetRecipeType);
                if (recipe != null) {
                    ChestMenu menu = new ChestMenu(this.getItemName());
                    menu.setPlayerInventoryClickable(false);
                    menu.setEmptySlotsClickable(false);
                    ChestMenuUtils.drawBackground(menu, this.background);
                    ChestMenuUtils.drawBackground(menu, 45, 46, 47, 48, 50, 51, 52, 53);
                    menu.addItem(49, CustomItemStack.create(Material.CRAFTING_TABLE, String.valueOf(ChatColor.GREEN) + Slimefun.getLocalization().getMessage(p, "messages.auto-crafting.select"), new String[0]));
                    menu.addMenuClickHandler(49, (pl, stack, slot, action) -> {
                        this.setSelectedRecipe(b, recipe);
                        SoundEffect.AUTO_CRAFTER_UPDATE_RECIPE.playAt(b);
                        Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.recipe-set");
                        this.showRecipe(p, b, recipe);
                        return false;
                    });
                    AsyncRecipeChoiceTask task = new AsyncRecipeChoiceTask();
                    recipe.show(menu, task);
                    menu.open(p);
                    SoundEffect.AUTO_CRAFTER_UPDATE_RECIPE.playAt(b);
                    if (!task.isEmpty()) {
                        task.start(menu.toInventory());
                    }
                } else {
                    Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.no-recipes");
                }
            }
        } else {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.no-recipes");
        }
    }
}

