/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.commands.subcommands;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.SubCommand;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

class BackpackCommand
extends SubCommand {
    @ParametersAreNonnullByDefault
    BackpackCommand(Slimefun plugin, SlimefunCommand cmd) {
        super(plugin, cmd, "backpack", false);
    }

    @Override
    protected String getDescription() {
        return "commands.backpack.description";
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (sender.hasPermission("slimefun.command.backpack")) {
                if (args.length != 3) {
                    Slimefun.getLocalization().sendMessage(sender, "messages.usage", true, msg -> msg.replace("%usage%", "/sf backpack <Player> <ID>"));
                    return;
                }
                if (!CommonPatterns.NUMERIC.matcher(args[2]).matches()) {
                    Slimefun.getLocalization().sendMessage(sender, "commands.backpack.invalid-id");
                    return;
                }
                OfflinePlayer backpackOwner = Bukkit.getOfflinePlayer((String)args[1]);
                if (!(backpackOwner instanceof Player) && !backpackOwner.hasPlayedBefore()) {
                    Slimefun.getLocalization().sendMessage(sender, "commands.backpack.player-never-joined");
                    return;
                }
                int id = Integer.parseInt(args[2]);
                PlayerProfile.get(backpackOwner, profile -> {
                    if (!profile.getBackpack(id).isPresent()) {
                        Slimefun.getLocalization().sendMessage(sender, "commands.backpack.backpack-does-not-exist");
                        return;
                    }
                    Slimefun.runSync(() -> {
                        ItemStack item = SlimefunItems.RESTORED_BACKPACK.clone();
                        Slimefun.getBackpackListener().setBackpackId(backpackOwner, item, 2, id);
                        player.getInventory().addItem(new ItemStack[]{item});
                        Slimefun.getLocalization().sendMessage(sender, "commands.backpack.restored-backpack-given");
                    });
                });
            } else {
                Slimefun.getLocalization().sendMessage(sender, "messages.no-permission", true);
            }
        } else {
            Slimefun.getLocalization().sendMessage(sender, "messages.only-players", true);
        }
    }
}

