/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils.biomes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.github.thebusybiscuit.slimefun4.api.exceptions.BiomeMapException;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import io.github.thebusybiscuit.slimefun4.utils.biomes.BiomeDataConverter;
import io.github.thebusybiscuit.slimefun4.utils.biomes.BiomeMap;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;

class BiomeMapParser<T> {
    private static final String VALUE_KEY = "value";
    private static final String BIOMES_KEY = "biomes";
    private final NamespacedKey key;
    private final BiomeDataConverter<T> valueConverter;
    private final Map<Biome, T> map = new EnumMap<Biome, T>(Biome.class);
    private boolean isLenient = false;

    @ParametersAreNonnullByDefault
    BiomeMapParser(NamespacedKey key, BiomeDataConverter<T> valueConverter) {
        Validate.notNull((Object)key, (String)"The key shall not be null.");
        Validate.notNull(valueConverter, (String)"You must provide a Function to convert raw json values to your desired data type.");
        this.key = key;
        this.valueConverter = valueConverter;
    }

    void setLenient(boolean isLenient) {
        this.isLenient = isLenient;
    }

    boolean isLenient() {
        return this.isLenient;
    }

    void read(@Nonnull String json) throws BiomeMapException {
        Validate.notNull((Object)json, (String)"The JSON string should not be null!");
        JsonArray root = null;
        try {
            JsonParser parser = new JsonParser();
            root = parser.parse(json).getAsJsonArray();
        }
        catch (JsonParseException | IllegalStateException x) {
            throw new BiomeMapException(this.key, x);
        }
        this.read(root);
    }

    void read(@Nonnull JsonArray json) throws BiomeMapException {
        Validate.notNull((Object)json, (String)"The JSON Array should not be null!");
        for (JsonElement element : json) {
            if (element instanceof JsonObject) {
                this.readEntry(element.getAsJsonObject());
                continue;
            }
            throw new BiomeMapException(this.key, "Unexpected array element: " + element.getClass().getSimpleName() + " - " + element.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readEntry(@Nonnull JsonObject entry) throws BiomeMapException {
        Validate.notNull((Object)entry, (String)"The JSON entry should not be null!");
        if (!entry.has(VALUE_KEY)) throw new BiomeMapException(this.key, "Entry is missing a 'value' child.");
        T value = this.valueConverter.convert(entry.get(VALUE_KEY));
        if (!entry.has(BIOMES_KEY) || !entry.get(BIOMES_KEY).isJsonArray()) throw new BiomeMapException(this.key, "Entry is missing a 'biomes' child of type array.");
        Set<Biome> biomes = this.readBiomes(entry.get(BIOMES_KEY).getAsJsonArray());
        for (Biome biome : biomes) {
            T prev = this.map.put(biome, value);
            if (prev == null) continue;
            throw new BiomeMapException(this.key, "Biome '" + biome.getKey() + "' is registered twice");
        }
    }

    @Nonnull
    private Set<Biome> readBiomes(@Nonnull JsonArray array) throws BiomeMapException {
        Validate.notNull((Object)array, (String)"The JSON array should not be null!");
        EnumSet<Biome> biomes = EnumSet.noneOf(Biome.class);
        for (JsonElement element : array) {
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                String value = element.getAsString();
                if (PatternUtils.MINECRAFT_NAMESPACEDKEY.matcher(value).matches()) {
                    String formattedValue = CommonPatterns.COLON.split(value)[1].toUpperCase(Locale.ROOT);
                    try {
                        Biome biome = Biome.valueOf((String)formattedValue);
                        biomes.add(biome);
                        continue;
                    }
                    catch (IllegalArgumentException x) {
                        if (this.isLenient) continue;
                        throw new BiomeMapException(this.key, "The Biome '" + value + "' does not exist!");
                    }
                }
                throw new BiomeMapException(this.key, "Could not recognize value '" + value + "'");
            }
            throw new BiomeMapException(this.key, "Unexpected array element: " + element.getClass().getSimpleName() + " - " + element.toString());
        }
        return biomes;
    }

    @Nonnull
    BiomeMap<T> buildBiomeMap() {
        BiomeMap<T> biomeMap = new BiomeMap<T>(this.key);
        biomeMap.putAll(this.map);
        return biomeMap;
    }
}

