/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.blocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AbstractMonsterSpawner
extends SlimefunItem {
    @ParametersAreNonnullByDefault
    AbstractMonsterSpawner(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    public Optional<EntityType> getEntityType(@Nonnull ItemStack item) {
        Validate.notNull((Object)item, (String)"The Item cannot be null");
        ItemMeta meta = item.getItemMeta();
        for (String line : meta.getLore()) {
            if (!ChatColor.stripColor((String)line).startsWith("Type: ") || line.contains("<Type>")) continue;
            EntityType type = EntityType.valueOf((String)ChatColor.stripColor((String)line).replace("Type: ", "").replace(' ', '_').toUpperCase(Locale.ROOT));
            return Optional.of(type);
        }
        return Optional.empty();
    }

    @Nonnull
    public ItemStack getItemForEntityType(@Nonnull EntityType type) {
        Validate.notNull((Object)type, (String)"The EntityType cannot be null");
        ItemStack item = this.getItem().clone();
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof BlockStateMeta) {
            BlockStateMeta stateMeta = (BlockStateMeta)meta;
            BlockState state = stateMeta.getBlockState();
            if (state instanceof CreatureSpawner) {
                ((CreatureSpawner)state).setSpawnedType(type);
            }
            stateMeta.setBlockState(state);
        }
        List lore = meta.getLore();
        for (int i = 0; i < lore.size(); ++i) {
            if (!((String)lore.get(i)).contains("<Type>")) continue;
            lore.set(i, ((String)lore.get(i)).replace("<Type>", ChatUtils.humanize(type.name())));
            break;
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }
}

