/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.items.settings;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.Validate;

public class IntRangeSetting
extends ItemSetting<Integer> {
    private final int min;
    private final int max;

    @ParametersAreNonnullByDefault
    public IntRangeSetting(SlimefunItem item, String key, int min, int defaultValue, int max) {
        super(item, key, defaultValue);
        Validate.isTrue((defaultValue >= min && defaultValue <= max ? 1 : 0) != 0, (String)"The default value is not in range.");
        this.min = min;
        this.max = max;
    }

    @Override
    @Nonnull
    protected String getErrorMessage() {
        return "Only whole numbers from " + this.min + '-' + this.max + "(inclusive) are allowed!";
    }

    @Override
    public boolean validateInput(Integer input) {
        return super.validateInput(input) && input >= this.min && input <= this.max;
    }

    public final int getMinimum() {
        return this.min;
    }

    public final int getMaximum() {
        return this.max;
    }
}

