/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.items.groups;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import java.time.LocalDate;
import java.time.Month;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SeasonalItemGroup
extends ItemGroup {
    private final Month month;

    @ParametersAreNonnullByDefault
    public SeasonalItemGroup(NamespacedKey key, Month month, int tier, ItemStack item) {
        super(key, item, tier);
        Validate.notNull((Object)month, (String)"The Month cannot be null");
        this.month = month;
    }

    @Nonnull
    public Month getMonth() {
        return this.month;
    }

    @Override
    public boolean isHidden(@Nonnull Player p) {
        if (this.month != LocalDate.now().getMonth()) {
            return true;
        }
        return super.isHidden(p);
    }
}

