/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest.apache;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.Config;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpRequest;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.RequestConfigFactory;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.RequestOptions;
import org.apache.http.client.config.RequestConfig;

class DefaultFactory
implements RequestConfigFactory {
    private static boolean isOldApache = false;

    DefaultFactory() {
    }

    @Override
    public RequestConfig apply(Config config, HttpRequest request) {
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(request.getConnectTimeout()).setSocketTimeout(request.getSocketTimeout()).setConnectionRequestTimeout(request.getSocketTimeout()).setProxy(RequestOptions.toApacheProxy(request.getProxy())).setCookieSpec(config.getCookieSpec());
        return this.tryNormalize(builder).build();
    }

    private RequestConfig.Builder tryNormalize(RequestConfig.Builder builder) {
        if (isOldApache) {
            return builder;
        }
        try {
            return builder.setNormalizeUri(false);
        }
        catch (NoSuchMethodError e) {
            isOldApache = true;
            return builder;
        }
    }
}

