/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.events;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSpawnReason;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public class SlimefunItemSpawnEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private Location location;
    private ItemStack itemStack;
    private boolean cancelled;
    private final ItemSpawnReason itemSpawnReason;

    @ParametersAreNonnullByDefault
    public SlimefunItemSpawnEvent(Location location, ItemStack itemStack, ItemSpawnReason itemSpawnReason) {
        this.location = location;
        this.itemStack = itemStack;
        this.itemSpawnReason = itemSpawnReason;
        this.cancelled = false;
    }

    @Nonnull
    public ItemSpawnReason getItemSpawnReason() {
        return this.itemSpawnReason;
    }

    @Nonnull
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(@Nonnull Location location) {
        Validate.notNull((Object)location, (String)"The Location cannot be null!");
        this.location = location;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(@Nonnull ItemStack itemStack) {
        Validate.notNull((Object)itemStack, (String)"Cannot drop null.");
        Validate.isTrue((!itemStack.getType().isAir() ? 1 : 0) != 0, (String)"Cannot drop air.");
        this.itemStack = itemStack;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Nonnull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Nonnull
    public HandlerList getHandlers() {
        return SlimefunItemSpawnEvent.getHandlerList();
    }
}

