/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ToolUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.Vein;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Axis;
import org.bukkit.Effect;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.inventory.ItemStack;

public class LumberAxe
extends SlimefunItem
implements NotPlaceable {
    private static final int MAX_BROKEN = 100;
    private static final int MAX_STRIPPED = 20;

    @ParametersAreNonnullByDefault
    public LumberAxe(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemHandler(this.onBlockBreak(), this.onItemUse());
    }

    @Nonnull
    private ToolUseHandler onBlockBreak() {
        return (e, tool, fortune, drops) -> {
            if (Tag.LOGS.isTagged((Keyed)e.getBlock().getType())) {
                List<Block> logs = Vein.find(e.getBlock(), 100, b -> Tag.LOGS.isTagged((Keyed)b.getType()));
                logs.remove(e.getBlock());
                for (Block b2 : logs) {
                    if (BlockStorage.hasBlockInfo(b2) || !Slimefun.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b2, Interaction.BREAK_BLOCK)) continue;
                    this.breakLog(b2);
                }
            }
        };
    }

    @Nonnull
    public ItemUseHandler onItemUse() {
        return e -> {
            Block block;
            if (e.getClickedBlock().isPresent() && this.isUnstrippedLog(block = e.getClickedBlock().get())) {
                List<Block> logs = Vein.find(block, 20, this::isUnstrippedLog);
                if (logs.contains(block)) {
                    logs.remove(block);
                }
                for (Block b : logs) {
                    if (BlockStorage.hasBlockInfo(b) || !Slimefun.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b, Interaction.BREAK_BLOCK)) continue;
                    this.stripLog(b);
                }
            }
        };
    }

    private boolean isUnstrippedLog(@Nonnull Block block) {
        return Tag.LOGS.isTagged((Keyed)block.getType()) && !block.getType().name().startsWith("STRIPPED_");
    }

    private void stripLog(@Nonnull Block b) {
        b.getWorld().playSound(b.getLocation(), Sound.ITEM_AXE_STRIP, 1.0f, 1.0f);
        Axis axis = ((Orientable)b.getBlockData()).getAxis();
        b.setType(Material.valueOf((String)("STRIPPED_" + b.getType().name())));
        Orientable orientable = (Orientable)b.getBlockData();
        orientable.setAxis(axis);
        b.setBlockData((BlockData)orientable);
    }

    private void breakLog(@Nonnull Block b) {
        b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
        for (ItemStack drop : b.getDrops(this.getItem())) {
            b.getWorld().dropItemNaturally(b.getLocation(), drop);
        }
        b.setType(Material.AIR);
    }
}

