/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest.apache;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.BasicResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Headers;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Proxy;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.RawResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.UnirestException;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.DefaultFactory;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.RequestConfigFactory;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.function.Function;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.impl.client.BasicCredentialsProvider;

abstract class BaseApacheClient {
    protected RequestConfigFactory configFactory = new DefaultFactory();

    BaseApacheClient() {
    }

    static CredentialsProvider toApacheCreds(Proxy proxy) {
        if (proxy != null && proxy.isAuthenticated()) {
            BasicCredentialsProvider proxyCreds = new BasicCredentialsProvider();
            proxyCreds.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword()));
            return proxyCreds;
        }
        return null;
    }

    protected <T> HttpResponse<T> transformBody(Function<RawResponse, HttpResponse<T>> transformer, RawResponse rr) {
        try {
            return transformer.apply(rr);
        }
        catch (RuntimeException e) {
            String originalBody = this.recoverBody(rr);
            return new BasicResponse(rr, originalBody, e);
        }
    }

    private String recoverBody(RawResponse rr) {
        try {
            return rr.getContentAsString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setConfigFactory(RequestConfigFactory configFactory) {
        this.configFactory = configFactory;
    }

    protected static HttpHost determineTarget(HttpUriRequest request, Headers headers) {
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute()) {
            target = URIUtils.extractHost(requestURI);
            if (target == null) {
                throw new UnirestException("URI does not specify a valid host name: " + requestURI);
            }
            if (headers.containsKey("Host") && InetAddressUtils.isIPv4Address(target.getHostName())) {
                try {
                    InetAddress address = InetAddress.getByName(target.getHostName());
                    target = new HttpHost(address, headers.getFirst("Host"), target.getPort(), target.getSchemeName());
                }
                catch (UnknownHostException e) {
                    throw new UnirestException(e);
                }
            }
        }
        return target;
    }
}

