/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.reflection;

import io.github.thebusybiscuit.slimefun4.libraries.dough.reflection.PrimitiveTypeConversion;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.UnknownServerVersionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;

public final class ReflectionUtils {
    private static String versionSpecificPackage;

    private ReflectionUtils() {
    }

    @Nonnull
    private static String getVersionSpecificPackage(boolean checkMinecraftVersion) throws UnknownServerVersionException {
        MinecraftVersion version;
        if (checkMinecraftVersion && (version = MinecraftVersion.get()).isAtLeast(1, 17)) {
            return "";
        }
        if (versionSpecificPackage == null) {
            String packageName = Bukkit.getServer().getClass().getPackage().getName();
            versionSpecificPackage = packageName.substring(packageName.lastIndexOf(46) + 1);
        }
        return versionSpecificPackage + '.';
    }

    @Nullable
    public static Method getMethod(@Nonnull Class<?> c, @Nonnull String method) {
        for (Method m : c.getMethods()) {
            if (!m.getName().equals(method)) continue;
            return m;
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@Nonnull Class<?> c, @Nonnull String method, Class<?> ... paramTypes) {
        Class<?>[] expectParamTypes = ReflectionUtils.toPrimitiveTypeArray(paramTypes);
        for (Method m : c.getMethods()) {
            Class<?>[] methodParameters = ReflectionUtils.toPrimitiveTypeArray(m.getParameterTypes());
            if (!m.getName().equals(method) || !ReflectionUtils.equalsTypeArray(methodParameters, expectParamTypes)) continue;
            return m;
        }
        return null;
    }

    @Nonnull
    public static Field getField(@Nonnull Class<?> c, @Nonnull String field) throws NoSuchFieldException {
        return c.getDeclaredField(field);
    }

    public static <T> void setFieldValue(@Nonnull T object, @Nonnull Class<?> c, @Nonnull String field, @Nullable Object value) throws NoSuchFieldException, IllegalAccessException {
        Field f = ReflectionUtils.getField(c, field);
        f.setAccessible(true);
        f.set(object, value);
    }

    public static <T> void setFieldValue(@Nonnull T object, @Nonnull String field, @Nullable Object value) throws NoSuchFieldException, IllegalAccessException {
        ReflectionUtils.setFieldValue(object, object.getClass(), field, value);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public static <T> T getFieldValue(Object object, Class<T> fieldType, String field) throws NoSuchFieldException, IllegalAccessException {
        Field f = ReflectionUtils.getField(object.getClass(), field);
        f.setAccessible(true);
        return fieldType.cast(f.get(object));
    }

    @Nonnull
    public static Class<?>[] toPrimitiveTypeArray(@Nonnull Class<?>[] classes) {
        int size = classes.length;
        Class[] types = new Class[size];
        for (int i = 0; i < size; ++i) {
            types[i] = PrimitiveTypeConversion.convertIfNecessary(classes[i]);
        }
        return types;
    }

    @Nullable
    public static <T> Constructor<T> getConstructor(@Nonnull Class<T> c, Class<?> ... paramTypes) {
        Class<?>[] expectedParamTypes = ReflectionUtils.toPrimitiveTypeArray(paramTypes);
        for (Constructor<?> constructor : c.getConstructors()) {
            Class<?>[] constructorTypes = ReflectionUtils.toPrimitiveTypeArray(constructor.getParameterTypes());
            if (!ReflectionUtils.equalsTypeArray(constructorTypes, expectedParamTypes)) continue;
            return constructor;
        }
        return null;
    }

    @Nonnull
    public static Class<?> getInnerNMSClass(@Nonnull String name, @Nonnull String subname) throws ClassNotFoundException, UnknownServerVersionException {
        return ReflectionUtils.getNMSClass(name + '$' + subname);
    }

    @Nonnull
    public static Class<?> getNetMinecraftClass(@Nonnull String name) throws ClassNotFoundException, UnknownServerVersionException {
        return Class.forName("net.minecraft." + ReflectionUtils.getVersionSpecificPackage(true) + name);
    }

    @Nonnull
    public static Class<?> getNMSClass(@Nonnull String name) throws ClassNotFoundException, UnknownServerVersionException {
        return Class.forName("net.minecraft.server." + ReflectionUtils.getVersionSpecificPackage(true) + name);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public static Class<?> getInnerOBCClass(String name, String subname) throws ClassNotFoundException {
        return ReflectionUtils.getOBCClass(name + '$' + subname);
    }

    @Nonnull
    public static Class<?> getOBCClass(@Nonnull String name) throws ClassNotFoundException {
        try {
            return Class.forName("org.bukkit.craftbukkit." + ReflectionUtils.getVersionSpecificPackage(false) + name);
        }
        catch (UnknownServerVersionException e) {
            throw new IllegalStateException("No version check should be performed here.", e);
        }
    }

    private static boolean equalsTypeArray(@Nonnull Class<?>[] a, Class<?>[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i]) || a[i].isAssignableFrom(b[i])) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public static <T extends Enum<T>> List<T> getEnumConstants(@Nonnull Class<T> c) {
        return Arrays.asList((Enum[])c.getEnumConstants());
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public static <T extends Enum<T>> T getEnumConstant(Class<T> c, String name) {
        for (Enum field : (Enum[])c.getEnumConstants()) {
            if (!field.toString().equals(name)) continue;
            return (T)field;
        }
        return null;
    }
}

