/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.armor.Parachute;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets.JetBoots;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets.Jetpack;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.InfusedMagnet;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.InfusedMagnetTask;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.JetBootsTask;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.JetpackTask;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.ParachuteTask;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class GadgetsListener
implements Listener {
    public GadgetsListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onToggleSneak(PlayerToggleSneakEvent e) {
        if (e.isSneaking()) {
            InfusedMagnet magnet;
            Player p = e.getPlayer();
            if (p.getInventory().getChestplate() != null) {
                SlimefunItem chestplate = SlimefunItem.getByItem(p.getInventory().getChestplate());
                this.handleChestplate(p, chestplate);
            }
            if (p.getInventory().getBoots() != null) {
                SlimefunItem boots = SlimefunItem.getByItem(p.getInventory().getBoots());
                this.handleBoots(p, boots);
            }
            if (SlimefunUtils.containsSimilarItem((Inventory)p.getInventory(), SlimefunItems.INFUSED_MAGNET, true) && (magnet = (InfusedMagnet)SlimefunItems.INFUSED_MAGNET.getItem()).canUse(p, true)) {
                new InfusedMagnetTask(p, magnet.getRadius()).scheduleRepeating(0L, 8L);
            }
        }
    }

    private void handleChestplate(@Nonnull Player p, @Nullable SlimefunItem chestplate) {
        if (chestplate == null || !chestplate.canUse(p, true)) {
            return;
        }
        if (chestplate instanceof Jetpack) {
            double thrust = ((Jetpack)chestplate).getThrust();
            if (thrust > 0.2) {
                new JetpackTask(p, (Jetpack)chestplate).scheduleRepeating(0L, 3L);
            }
        } else if (chestplate instanceof Parachute) {
            new ParachuteTask(p).scheduleRepeating(0L, 3L);
        }
    }

    private void handleBoots(@Nonnull Player p, @Nullable SlimefunItem boots) {
        double speed;
        if (boots instanceof JetBoots && boots.canUse(p, true) && (speed = ((JetBoots)boots).getSpeed()) > 0.2) {
            new JetBootsTask(p, (JetBoots)boots).scheduleRepeating(0L, 2L);
        }
    }
}

